/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import einstein.subtle_effects.client.model.entity.EinsteinSolarSystemModel;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemArmorLayer;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemRenderLayerParentImpl;
import einstein.subtle_effects.client.renderer.entity.PartyHatLayer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.joml.Vector3f;

public class EinsteinSolarSystemLayer<T extends AbstractClientPlayer, V extends PlayerModel<T>>
extends RenderLayer<T, V> {
    private static final Vector3f[] HEAD_ROTATIONS = new Vector3f[]{new Vector3f(27.6f, 61.0f, -9.7f), new Vector3f(2.5f, 8.6f, -13.8f), new Vector3f(-64.7f, 48.2f, -41.9f)};
    private final EinsteinSolarSystemRenderLayerParentImpl<T, V> renderLayerParent;
    private final EinsteinSolarSystemModel<T> model;
    private final CustomHeadLayer<T, EinsteinSolarSystemModel<T>> headLayer;
    private final EinsteinSolarSystemArmorLayer<T, EinsteinSolarSystemModel<T>, HumanoidModel<T>> armorLayer;
    private final PartyHatLayer<T, EinsteinSolarSystemModel<T>> partyHatLayer;

    public EinsteinSolarSystemLayer(RenderLayerParent<T, V> renderer, EntityRendererProvider.Context context) {
        super(renderer);
        this.model = new EinsteinSolarSystemModel(context.bakeLayer(EinsteinSolarSystemModel.MODEL_LAYER));
        this.renderLayerParent = new EinsteinSolarSystemRenderLayerParentImpl(this);
        this.headLayer = new CustomHeadLayer(this.renderLayerParent, context.getModelSet(), context.getItemInHandRenderer());
        this.armorLayer = new EinsteinSolarSystemArmorLayer<T, V, HumanoidArmorModel>(this.renderLayerParent, new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager());
        if (PartyHatLayer.isModBirthday(false)) {
            this.partyHatLayer = new PartyHatLayer<T, V>(this.renderLayerParent, context);
            return;
        }
        this.partyHatLayer = null;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (EinsteinSolarSystemLayer.shouldRender(player)) {
            int headCount = HEAD_ROTATIONS.length;
            this.model.hat.visible = player.isModelPartShown(PlayerModelPart.HAT);
            for (int i = 0; i < headCount; ++i) {
                float i1 = i + 1;
                float spin = EinsteinSolarSystemLayer.getSpin(partialTicks, player, i) * ((float)headCount / i1);
                Vector3f rotation = HEAD_ROTATIONS[i];
                poseStack.pushPose();
                poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f - Mth.rotLerp((float)partialTicks, (float)((AbstractClientPlayer)player).yBodyRotO, (float)((AbstractClientPlayer)player).yBodyRot)));
                poseStack.mulPose(Axis.YP.rotation(spin));
                poseStack.translate(0.7 * (double)i1, player.isCrouching() ? 0.0 : -0.25, 0.0);
                poseStack.scale(0.8f, 0.8f, 0.8f);
                poseStack.pushPose();
                poseStack.mulPose(Axis.XP.rotationDegrees(rotation.x()));
                poseStack.mulPose(Axis.YP.rotationDegrees(rotation.y()));
                poseStack.mulPose(Axis.ZP.rotationDegrees(rotation.z()));
                poseStack.mulPose(Axis.YP.rotation(spin));
                VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(player)));
                this.model.renderToBuffer(poseStack, consumer, packedLight, LivingEntityRenderer.getOverlayCoords(player, (float)0.0f), -1);
                poseStack.translate(0.0, 0.25, 0.0);
                this.headLayer.render(poseStack, bufferSource, packedLight, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                this.armorLayer.render(poseStack, bufferSource, packedLight, (LivingEntity)player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                if (this.partyHatLayer != null) {
                    this.partyHatLayer.render(poseStack, bufferSource, packedLight, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
                poseStack.popPose();
                poseStack.popPose();
            }
        }
    }

    public ResourceLocation getTextureLocation(T player) {
        return super.getTextureLocation(player);
    }

    public EinsteinSolarSystemModel<T> getModel() {
        return this.model;
    }

    public EinsteinSolarSystemRenderLayerParentImpl<T, V> getRenderLayerParent() {
        return this.renderLayerParent;
    }

    public static boolean shouldRender(AbstractClientPlayer player) {
        return ModConfigs.GENERAL.enableEasterEggs && (Util.isMincraftEinstein(player) || Services.PLATFORM.isDevelopmentEnvironment()) && !player.isInvisible();
    }

    public static float getSpin(float partialTicks, AbstractClientPlayer player, float speed) {
        return ((float)player.tickCount + partialTicks) / 20.0f + (float)Math.PI * speed;
    }
}

