/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.sdrp.config;

import com.jagrosh.discordipc.entities.RichPresence;
import com.sunekaer.sdrp.discord.State;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@Config(name="sdrp-common")
public class SDRPConfig
implements ConfigData {
    @Comment(value="Your Discord App ID")
    public long clientId = 608012526537408579L;
    @Comment(value="If you wish to disable Discord Rich Presence, set this to false.")
    public boolean enabled = true;
    @Comment(value="When enabled, the mod will log the current state being sent to Discord")
    public boolean logState = false;
    @Comment(value="Set custom buttons for the Discord Rich Presences. You can only have 2 buttons, each button has a label and a URL.\n\nExample:\n[\n    {\n        \"label\": \"Join our Discord!\",\n        \"url\": \"https://discord.gg/...\n    },\n    ...\n]\n")
    public List<Button> buttons = new ArrayList<Button>();
    @Comment(value="If set to false, it disables the build-in clientJoinEvent, which is used to tell when the player joins a world and changing Dimension.")
    public boolean enableUpdateDimensionPresence = true;
    @Comment(value="Dimensions can be setup to update the Rich Presence when the player is in them.\n\nDue to the complex nature of modded dimensions, we've added support for different matchers here with\nsupport for variable replacement in the various fields.\n\nNote: When comparing, the full dimension identifier is used (e.g. minecraft:overworld, modid:custom_dimension) meaning if you use\na startsWith, regex, etc, you need to handle the namespace as well.\n\nHelper matchers are provided for doing blanket matches on just the namespace or path.\n\nSupported matchers:\n- exact@<string> : Exact match\n- contains@<string> : Contains substring\n- startsWith@<string> : Starts with substring\n- endsWith@<string> : Ends with substring\n- regex@<pattern> : Matches regex pattern (Java regex syntax)\n- namespace@<string> : Matches namespace\n- path@<string> : Matches path\n\nVariables:\n- {{dimension.name}}: The translated dimension name (e.g. dimension.minecraft.overworld = Overworld). This is NeoForge standards, not all mods follow this, nor will all have their own lang keys added.\n- {{dimension.path}}: The dimension identifier (e.g. overworld) excluding the namespace\n- {{dimension.namespace}}: The dimension namespace (e.g. minecraft, modid)\n- {{dimension.identifier}}: The full dimension identifier (e.g. minecraft:overworld)\n- {{player.uuid}}: The player's UUID\n- {{player.name}}: The player's in-game name\n- Please let us know if there are any other variables you'd like to see added!\n")
    public List<DimensionEntry> dimensionsSupport = new ArrayList<DimensionEntry>();
    @Comment(value="If set to false, it disables the build-in screenEvent, which is used to tell when we are on the main menu, or other enabled screens.")
    public boolean enableUpdateScreenPresence = true;
    @Comment(value="Screens can be setup to update the Rich Presence when the player is on them. You can specify multiple screen classes for each entry.\nEach screen should have a message, imageName and imageKey.\n\nExample:\n[\n    {\n        \"screenClass\": [\n            \"net.minecraft.client.gui.screens.TitleScreen\"\n        ],\n        \"message\": \"sdrp.mainmenu\",\n        \"imageName\": \"sdrp.mainmenu\",\n        \"imageKey\": \"menu\"\n    },\n    ...\n]\n\nThis would update the Rich Presence when on the Title Screen to have the message and images specified.\n")
    public List<ScreenTranslation> screens = new ArrayList<ScreenTranslation>();

    public void validatePostLoad() throws ConfigData.ValidationException {
        if (this.screens.isEmpty()) {
            this.screens.add(new ScreenTranslation(List.of("net.minecraft.client.gui.screens.TitleScreen", "net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen", "net.minecraft.client.gui.screens.worldselection.SelectWorldScreen"), "sdrp.mainmenu", "sdrp.mainmenu", "menu"));
        }
        if (this.dimensionsSupport.isEmpty()) {
            this.dimensionsSupport.addAll(List.of(new DimensionEntry("exact@minecraft:overworld", "{{dimension.name}}", "{{dimension.name}}", "{{dimension.path}}"), new DimensionEntry("exact@minecraft:the_nether", "{{dimension.name}}", "{{dimension.name}}", "{{dimension.path}}"), new DimensionEntry("exact@minecraft:the_end", "{{dimension.name}}", "{{dimension.name}}", "{{dimension.path}}")));
        }
    }

    public static final class ScreenTranslation
    extends State {
        public List<String> screenClass;

        public ScreenTranslation() {
            super("", "", "");
            this.screenClass = new ArrayList<String>();
        }

        public ScreenTranslation(List<String> screenClass, String message, String imageName, String imageKey) {
            super(message, imageName, imageKey);
            this.screenClass = screenClass;
        }
    }

    public static final class DimensionEntry {
        public String matcher;
        public String message;
        public String imageName;
        public String imageKey;
        private final boolean prefixWithIn;

        public DimensionEntry() {
            this.prefixWithIn = true;
        }

        public DimensionEntry(String matcher, String message, String imageName, String imageKey, boolean prefixWithIn) {
            this.matcher = matcher;
            this.message = message;
            this.imageName = imageName;
            this.imageKey = imageKey;
            this.prefixWithIn = prefixWithIn;
        }

        public DimensionEntry(String matcher, String message, String imageName, String imageKey) {
            this(matcher, message, imageName, imageKey, true);
        }

        public boolean matches(String compareTo) {
            if (!this.matcher.contains("@")) {
                return this.matcher.equals(compareTo);
            }
            String[] parts = this.matcher.split("@", 2);
            String matchType = parts[0];
            String matchValue = parts[1];
            return switch (matchType) {
                case "exact" -> compareTo.equals(matchValue);
                case "contains" -> compareTo.contains(matchValue);
                case "startsWith" -> compareTo.startsWith(matchValue);
                case "endsWith" -> compareTo.endsWith(matchValue);
                case "regex" -> compareTo.matches(matchValue);
                case "namespace" -> {
                    ResourceLocation rl = ResourceLocation.tryParse((String)compareTo);
                    if (rl != null && rl.getNamespace().equals(matchValue)) {
                        yield true;
                    }
                    yield false;
                }
                case "path" -> {
                    ResourceLocation rl = ResourceLocation.tryParse((String)compareTo);
                    if (rl != null && rl.getPath().equals(matchValue)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public RichPresence createPresence(ResourceLocation dimensionName, Player player) {
            Object msg = DimensionEntry.processVariables(this.message, dimensionName, player);
            if (this.prefixWithIn) {
                msg = I18n.get((String)"sdrp.in", (Object[])new Object[0]) + " " + I18n.get((String)msg, (Object[])new Object[0]);
            }
            return new State((String)msg, DimensionEntry.processVariables(this.imageName, dimensionName, player), DimensionEntry.processVariables(this.imageKey, dimensionName, player)).createPresence();
        }

        public static String processVariables(String template, ResourceLocation dimensionName, Player player) {
            return template.replace("{{dimension.name}}", I18n.get((String)dimensionName.toLanguageKey("dimension"), (Object[])new Object[0])).replace("{{dimension.identifier}}", dimensionName.toString()).replace("{{dimension.namespace}}", dimensionName.getNamespace()).replace("{{dimension.path}}", dimensionName.getPath()).replace("{{player.uuid}}", player.getUUID().toString()).replace("{{player.name}}", player.getName().getString());
        }

        public String matcher() {
            return this.matcher;
        }

        public String message() {
            return this.message;
        }

        public String imageName() {
            return this.imageName;
        }

        public String imageKey() {
            return this.imageKey;
        }

        public boolean prefixWithIn() {
            return this.prefixWithIn;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DimensionEntry that = (DimensionEntry)obj;
            return Objects.equals(this.matcher, that.matcher) && Objects.equals(this.message, that.message) && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.imageKey, that.imageKey) && this.prefixWithIn == that.prefixWithIn;
        }

        public int hashCode() {
            return Objects.hash(this.matcher, this.message, this.imageName, this.imageKey, this.prefixWithIn);
        }

        public String toString() {
            return "DimensionEntry[matcher=" + this.matcher + ", message=" + this.message + ", imageName=" + this.imageName + ", imageKey=" + this.imageKey + ", prefixWithIn=" + this.prefixWithIn + "]";
        }
    }

    public static final class Button {
        public String label;
        public String url;
    }
}

