/*
 * Decompiled with CFR 0.152.
 */
package computer.heather.serverstarted.config;

import computer.heather.serverstarted.ServerStarted;
import computer.heather.serverstarted.config.ConfigTypes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConfigManager {
    private static HashMap<String, ConfigTypes> entries = new HashMap();
    public static final ConfigTypes.BooleanValue enabled = new ConfigTypes.BooleanValue("config.serverstarted.enabled", true, ConfigManager::register);
    public static final ConfigTypes.LongValue delay = new ConfigTypes.LongValue("config.serverstarted.delay", 50L, 1L, Integer.MAX_VALUE, ConfigManager::register);
    public static final ConfigTypes.FreeStringValue message = new ConfigTypes.FreeStringValue("config.serverstarted.message", "Server Started!", ConfigManager::register);

    public static void register(String key, ConfigTypes configType) {
        entries.put(key, configType);
    }

    public static void loadOrCreateConfig() {
        File file;
        File dir = new File("./config");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir, "ServerStarted.properties")).exists()) {
            ConfigManager.writeConfig();
        }
        ConfigManager.loadConfig();
    }

    private static void writeConfig() {
        ServerStarted.LOGGER.info("Preparing to write to properties file...");
        File file = new File("./config/ServerStarted.properties");
        try {
            file.createNewFile();
            file.setWritable(true);
            InputStream is = ConfigManager.class.getClassLoader().getResourceAsStream("serverstarted-properties.txt");
            String text = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            for (String key : entries.keySet()) {
                Matcher matcher = Pattern.compile(Pattern.quote(key) + "$", 8).matcher(text);
                text = matcher.replaceAll(key + "=" + entries.get(key).save());
            }
            FileWriter writer = new FileWriter(file);
            writer.write(text);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadConfig() {
        Properties props = new Properties();
        File file = new File("./config/ServerStarted.properties");
        try {
            FileReader reader = new FileReader(file);
            props.load(reader);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        ArrayList<String> missingProps = new ArrayList<String>();
        for (String key : entries.keySet()) {
            if (!props.containsKey(key)) {
                missingProps.add(key);
                ServerStarted.LOGGER.warn("Missing key : " + key);
                continue;
            }
            ConfigTypes.ConfigValidationEnum valid = entries.get(key).validate(props.getProperty(key));
            if (valid != ConfigTypes.ConfigValidationEnum.VALID) {
                missingProps.add(key);
                ServerStarted.LOGGER.warn(valid.getError() + " : " + key);
                continue;
            }
            entries.get(key).load(props.getProperty(key));
        }
        if (!missingProps.isEmpty()) {
            ServerStarted.LOGGER.warn("The following properties were missing from the loaded file :");
            for (String string : missingProps) {
                ServerStarted.LOGGER.warn(string);
            }
            ServerStarted.LOGGER.warn("Properties file will be regenerated! Existing config values will be preserved.");
            ConfigManager.writeConfig();
        }
    }
}

