/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonTime;

public class SeasonHooks {
    public static boolean shouldSnowHook(Biome biome, LevelReader levelReader, BlockPos pos) {
        BlockState blockstate;
        if (ModConfig.seasons.generateSnowAndIce && SeasonHooks.warmEnoughToRainSeasonal(levelReader, pos) || !ModConfig.seasons.generateSnowAndIce && biome.warmEnoughToRain(pos)) {
            return false;
        }
        return pos.getY() >= levelReader.getMinBuildHeight() && pos.getY() < levelReader.getMaxBuildHeight() && levelReader.getBrightness(LightLayer.BLOCK, pos) < 10 && (blockstate = levelReader.getBlockState(pos)).isAir() && Blocks.SNOW.defaultBlockState().canSurvive(levelReader, pos);
    }

    public static boolean shouldFreezeWarmEnoughToRainHook(Biome biome, BlockPos pos, LevelReader levelReader) {
        return ModConfig.seasons.generateSnowAndIce && SeasonHooks.warmEnoughToRainSeasonal(levelReader, pos) || !ModConfig.seasons.generateSnowAndIce && biome.warmEnoughToRain(pos);
    }

    public static boolean isRainingAtHook(Level level, BlockPos position) {
        if (!level.isRaining()) {
            return false;
        }
        if (!level.canSeeSky(position)) {
            return false;
        }
        if (level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, position).getY() > position.getY()) {
            return false;
        }
        Holder biome = level.getBiome(position);
        if (ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)level.dimension()) && !biome.is(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return SeasonHooks.getPrecipitationAtSeasonal(level, (Holder<Biome>)biome, position) == Biome.Precipitation.RAIN && SeasonHooks.warmEnoughToRainSeasonal((LevelReader)level, (Holder<Biome>)biome, position);
        }
        return ((Biome)biome.value()).getPrecipitationAt(position) == Biome.Precipitation.RAIN && ((Biome)biome.value()).getTemperature(position) >= 0.15f;
    }

    public static Biome.Precipitation getPrecipitationAtTickIceAndSnowHook(LevelReader level, Biome biome, BlockPos pos) {
        if (!biome.hasPrecipitation()) {
            return Biome.Precipitation.NONE;
        }
        boolean shouldSnow = ModConfig.seasons.generateSnowAndIce && SeasonHooks.coldEnoughToSnowSeasonal(level, pos) || !ModConfig.seasons.generateSnowAndIce && biome.coldEnoughToSnow(pos);
        return shouldSnow ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }

    public static boolean coldEnoughToSnowSeasonal(LevelReader level, BlockPos pos) {
        return SeasonHooks.coldEnoughToSnowSeasonal(level, (Holder<Biome>)level.getBiome(pos), pos);
    }

    public static boolean coldEnoughToSnowSeasonal(LevelReader level, Holder<Biome> biome, BlockPos pos) {
        return !SeasonHooks.warmEnoughToRainSeasonal(level, biome, pos);
    }

    public static boolean warmEnoughToRainSeasonal(LevelReader level, BlockPos pos) {
        return SeasonHooks.warmEnoughToRainSeasonal(level, (Holder<Biome>)level.getBiome(pos), pos);
    }

    public static boolean warmEnoughToRainSeasonal(LevelReader level, Holder<Biome> biome, BlockPos pos) {
        return SeasonHooks.getBiomeTemperature(level, biome, pos) >= 0.15f;
    }

    public static float getBiomeTemperature(LevelReader level, Holder<Biome> biome, BlockPos pos) {
        if (!(level instanceof Level)) {
            return ((Biome)biome.value()).getTemperature(pos);
        }
        return SeasonHooks.getBiomeTemperature((Level)level, biome, pos);
    }

    public static float getBiomeTemperature(Level level, Holder<Biome> biome, BlockPos pos) {
        if (!ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)level.dimension()) || biome.is(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return ((Biome)biome.value()).getTemperature(pos);
        }
        return SeasonHooks.getBiomeTemperatureInSeason(new SeasonTime(SeasonHelper.getSeasonState(level).getSeasonCycleTicks()).getSubSeason(), biome, pos);
    }

    public static float getBiomeTemperatureInSeason(Season.SubSeason subSeason, Holder<Biome> biome, BlockPos pos) {
        boolean tropicalBiome = biome.is(ModTags.Biomes.TROPICAL_BIOMES);
        float biomeTemp = ((Biome)biome.value()).getTemperature(pos);
        if (!tropicalBiome && ((Biome)biome.value()).getBaseTemperature() <= 0.8f && !biome.is(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            biomeTemp = Mth.clamp((float)(biomeTemp + ModConfig.seasons.getSeasonProperties(subSeason).biomeTempAdjustment()), (float)-0.5f, (float)2.0f);
        }
        return biomeTemp;
    }

    public static boolean hasPrecipitationSeasonal(Level level, Holder<Biome> biome) {
        if (biome.is(ModTags.Biomes.TROPICAL_BIOMES)) {
            Season.TropicalSeason tropicalSeason = SeasonHelper.getSeasonState(level).getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return false;
                }
                case MID_WET: {
                    return true;
                }
            }
        }
        return ((Biome)biome.value()).hasPrecipitation();
    }

    public static Biome.Precipitation getPrecipitationAtSeasonal(Level level, Holder<Biome> biome, BlockPos pos) {
        if (!SeasonHooks.hasPrecipitationSeasonal(level, biome)) {
            return Biome.Precipitation.NONE;
        }
        return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, biome, pos) ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }
}

