/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.world.processor;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.ribbits.module.BlockModule;
import com.yungnickyoung.minecraft.ribbits.module.StructureProcessorTypeModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LapisBlockProcessor
extends StructureProcessor {
    public static final LapisBlockProcessor INSTANCE = new LapisBlockProcessor();
    public static final MapCodec<LapisBlockProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().is(Blocks.LAPIS_BLOCK)) {
            BlockState blockStateBelow;
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos()))) {
                return blockInfoGlobal;
            }
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            StructureTemplate.StructureBlockInfo structureBlockInfo = blockInfoGlobal = random.nextFloat() < 0.9f ? new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.WATER.defaultBlockState(), null) : new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.SEAGRASS.defaultBlockState(), null);
            if (random.nextFloat() < 0.1f) {
                levelReader.getChunk(blockInfoGlobal.pos().above()).setBlockState(blockInfoGlobal.pos().above(), ((Block)BlockModule.GIANT_LILYPAD.get()).defaultBlockState(), false);
            }
            if (!(blockStateBelow = levelReader.getBlockState(blockInfoGlobal.pos().below())).isSolidRender((BlockGetter)levelReader, blockInfoGlobal.pos().below())) {
                levelReader.getChunk(blockInfoGlobal.pos().below()).setBlockState(blockInfoGlobal.pos().below(), Blocks.DIRT.defaultBlockState(), false);
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.LAPIS_BLOCK_PROCESSOR;
    }
}

