/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RibbitStrollGoal
extends RandomStrollGoal {
    private final int dayHomeRange;
    private final RibbitEntity ribbit;

    public RibbitStrollGoal(RibbitEntity mob, double speedModifier, int dayHomeRange) {
        super((PathfinderMob)mob, speedModifier);
        this.ribbit = mob;
        this.dayHomeRange = dayHomeRange;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public RibbitStrollGoal(RibbitEntity mob, double speedModifier, int interval, int dayHomeRange) {
        super((PathfinderMob)mob, speedModifier, interval);
        this.ribbit = mob;
        this.dayHomeRange = dayHomeRange;
    }

    public RibbitStrollGoal(RibbitEntity mob, double speedModifier, int interval, boolean checkNoActionTime, int dayHomeRange) {
        super((PathfinderMob)mob, speedModifier, interval, checkNoActionTime);
        this.ribbit = mob;
        this.dayHomeRange = dayHomeRange;
    }

    public void start() {
        float waterModifier = this.ribbit.isInWater() ? 2.0f : 1.0f;
        this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier * (double)waterModifier);
    }

    public boolean canUse() {
        if (this.ribbit.level().isNight()) {
            return false;
        }
        return super.canUse();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        super.tick();
        float waterModifier = this.ribbit.isInWater() ? 2.0f : 1.0f;
        this.ribbit.getNavigation().setSpeedModifier(this.speedModifier * (double)waterModifier);
    }

    @Nullable
    protected Vec3 getPosition() {
        BlockPos distanceVariance = new BlockPos(this.mob.getRandom().nextInt(this.dayHomeRange * 2) - this.dayHomeRange, this.mob.getRandom().nextInt(this.dayHomeRange * 2) - this.dayHomeRange, this.mob.getRandom().nextInt(this.dayHomeRange * 2) - this.dayHomeRange);
        return new Vec3((double)(distanceVariance.getX() + this.ribbit.getHomePosition().getX()), (double)(distanceVariance.getY() + this.ribbit.getHomePosition().getY()), (double)(distanceVariance.getZ() + this.ribbit.getHomePosition().getZ()));
    }
}

