---
navigation:
  title: Replication
  icon: replication:replicator
item_ids:
  - replication:replicator
  - replication:matter_network_pipe
  - replication:identification_chamber
  - replication:disintegrator
  - replication:matter_tank
  - replication:replication_terminal
  - replication:chip_storage
  - replication:replicator_enclosure
  - replication:replicator_motor
---

# Replication

**Replication**是一款科技模组，你可以借助本模组复制相似类别的资源。例如将泥土转换成石头，但无法将泥土转换成钻石。

## 重要概念

**物质管道**可以连接模组内各种机器，且可以自动完成以下操作：

* 传输**能量**：类似于其他能量管道
* 传输**物质**：将物质从**分解器**传输到**物质储罐**，或从**物质储罐**传输到需要物质的**其他机器**

**鉴定室**会扫描物品以获取物质构成，然后将物质值存入存储芯片。**芯片**可放入**芯片仓**，之后可在网络中使用。若将芯片仓放在鉴定室的上方，则在每次扫描完成后，数据模型将会直接传输到芯片仓，而不再需要通过芯片中介。

**复制仓**可以设置为“无限模式”。这个模式下，复制仓将持续复制特定资源，直到自身填满或物质耗尽。可以在GUI中配置模式。

## 工作原理

在转换物品前，你需要先让物品在**分解器**中被拆解成原始的物质值。这台机器可以将所有含物质值的物品转换成物质。扫描完毕后，物品将以物质值的形式存储在芯片中，随后可使用**复制终端**请求物品。发出请求后，**复制器**使用储罐内的物质重新创造出物品，然后送回终端。

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="setup.snbt" />
  <IsometricCamera  yaw="30" pitch="30" />
</GameScene>

## 加速组件

* 复制器外罩：潜行并右击复制器，可为其安装外罩。外罩可令复制速度加快20%，但能量消耗增加10%。
* 复制器马达：潜行并右击复制器，可为其安装马达。随后可以设置复制器的工作速度增幅，默认消耗时间为100%，最快可缩短为原时长的20%。机器运行越快，失败的可能性就越大。复制失败时，机器会需要重新执行复制工作，但不会额外消耗物质。要合成复制器马达，你需要合成对应蓝图，然后在芯片仓使用蓝图，从而直接复制出复制器马达。

## 万物源典

万物源典是一个含有搜索功能的列表，可以搜索特定物质值的物品。你可以通过复制终端屏幕上搜索栏左侧的按钮进入万物源典界面，或单击终端右侧
陈列的物质

万物源典的搜索栏接受：

* 任意物质的名称：显示所有含此类物质的物品
* `大地>10`：只显示含有多于10点大地物质的物品
* `下界=20`：只显示含有正好20点下界物质的物品
* `量子<6`：只显示含有少于6点量子物质的物品
* `!大地`：只显示不含有大地物质的物品
* `*金属`：只显示仅含有金属物质的物品