/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.compat.jade;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationConfig;
import com.buuz135.replication.api.matter_fluid.MatterStack;
import com.buuz135.replication.block.tile.BaseMatterTankBlockEntity;
import com.buuz135.replication.util.NumberUtils;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ProgressElement;

public class MatterTankComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static ResourceLocation MATTER_TANK_LOCATION = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"matter_tank");

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        if (blockAccessor.getServerData().contains("MatterStack")) {
            MatterStack matterStack = MatterStack.loadMatterStackFromNBT(blockAccessor.getServerData().getCompound("MatterStack"));
            float[] floatColor = matterStack.getMatterType().getColor().get();
            Color color = new Color(floatColor[0], floatColor[1], floatColor[2], floatColor[3]);
            iTooltip.add((IElement)new ProgressElement((float)(matterStack.getAmount() / (double)ReplicationConfig.MatterTank.CAPACITY), (Component)(matterStack.isEmpty() ? Component.translatable((String)"tooltip.titanium.tank.empty") : Component.translatable((String)matterStack.getTranslationKey()).append(" ").append(NumberUtils.getFormatedBigNumber(matterStack.getAmount()))), IElementHelper.get().progressStyle().color(color.getRGB()).textColor(0xFFFFFF), BoxStyle.getNestedBox(), false));
        }
    }

    public ResourceLocation getUid() {
        return MATTER_TANK_LOCATION;
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BaseMatterTankBlockEntity blockEntity = (BaseMatterTankBlockEntity)blockAccessor.getBlockEntity();
        compoundTag.put("MatterStack", (Tag)blockEntity.getTanks().get(0).getMatter().writeToNBT(new CompoundTag()));
    }
}

