/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.gui.button;

import com.buuz135.replication.ReplicationRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class ReplicationTerminalTexturedCheckbox
extends Checkbox {
    private final ResourceLocation textureRL;
    private final boolean showLabel;
    private final int textureX;
    private final int textureY;

    public ReplicationTerminalTexturedCheckbox(int pX, int pY, int pWidth, int pHeight, Component component, ResourceLocation textureRL, int textureX, int textureY, boolean pSelected, boolean pShowLabel) {
        super(pX, pY, pWidth, component, Minecraft.getInstance().font, pSelected, (checkbox, b) -> {});
        this.height = pHeight;
        this.textureRL = textureRL;
        this.textureX = textureX;
        this.textureY = textureY;
        this.showLabel = pShowLabel;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.enableDepthTest();
        Font font = minecraft.font;
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        if (super.selected()) {
            guiGraphics.blit(this.textureRL, this.getX(), this.getY(), this.textureX, this.textureY, this.width, this.height);
        } else {
            guiGraphics.blit(this.textureRL, this.getX(), this.getY(), this.textureX + 9, this.textureY, this.width, this.height);
        }
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.showLabel) {
            guiGraphics.drawString(font, this.getMessage(), this.getX() + 24, this.getY() + (this.height - 8) / 2, 0xE0E0E0 | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }
    }

    public void playDownSound(SoundManager pHandler) {
        pHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ReplicationRegistry.Sounds.TERMINAL_BUTTON.get()), (float)1.0f));
    }
}

