/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.block;

import com.buuz135.replication.ReplicationAttachments;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.block.shapes.MatterTankShapes;
import com.buuz135.replication.block.tile.MatterTankBlockEntity;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatterTankBlock
extends RotatableBlock<MatterTankBlockEntity>
implements INetworkDirectionalConnection {
    public MatterTankBlock() {
        super("matter_tank", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), MatterTankBlockEntity.class);
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return (pos, blockState) -> new MatterTankBlockEntity((BasicTileBlock<MatterTankBlockEntity>)this, (BlockEntityType<?>)((BlockEntityType)ReplicationRegistry.Blocks.MATTER_TANK.type().get()), pos, blockState, () -> false);
    }

    @NotNull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return MatterTankShapes.SHAPE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return MatterTankShapes.SHAPE;
    }

    public boolean canConnect(Level level, BlockPos pos, BlockState state, Direction direction) {
        return direction == Direction.UP || direction == Direction.DOWN;
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        return blockLootTables.droppingNothing();
    }

    public List<ItemStack> getDrops(BlockState p_60537_, LootParams.Builder builder) {
        MatterTankBlockEntity tile;
        NonNullList stacks = NonNullList.create();
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity tankTile = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (tankTile instanceof MatterTankBlockEntity && !(tile = (MatterTankBlockEntity)tankTile).getTanks().get(0).getMatter().isEmpty()) {
            stack.set(ReplicationAttachments.TILE, (Object)NBTManager.getInstance().writeTileEntity((BlockEntity)tile, new CompoundTag()));
        }
        stacks.add((Object)stack);
        return stacks;
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.create();
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState p_49849_, @Nullable LivingEntity p_49850_, ItemStack stack) {
        super.setPlacedBy(level, pos, p_49849_, p_49850_, stack);
        BlockEntity entity = level.getBlockEntity(pos);
        if (stack.has(ReplicationAttachments.TILE) && entity instanceof MatterTankBlockEntity) {
            MatterTankBlockEntity tile = (MatterTankBlockEntity)entity;
            entity.loadCustomOnly((CompoundTag)stack.get(ReplicationAttachments.TILE), (HolderLookup.Provider)entity.getLevel().registryAccess());
            tile.markForUpdate();
        }
    }

    public void registerRecipe(RecipeOutput consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("IGI").pattern("G G").pattern("IGI").define(Character.valueOf('I'), (ItemLike)ReplicationRegistry.Items.REPLICA_INGOT.get()).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).save(consumer);
    }
}

