/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.network;

import com.buuz135.replication.Replication;
import com.buuz135.replication.network.MatterNetwork;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.block_network.element.NetworkElementFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class DefaultMatterNetworkElement
extends NetworkElement {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"default_matter");

    public DefaultMatterNetworkElement(Level level, BlockPos pos) {
        super(level, pos);
    }

    public void joinNetwork(Network network) {
        super.joinNetwork(network);
        if (network instanceof MatterNetwork) {
            MatterNetwork matterNetwork = (MatterNetwork)network;
            matterNetwork.addElement(this);
        }
    }

    public void leaveNetwork() {
        Network network = this.network;
        if (network instanceof MatterNetwork) {
            MatterNetwork matterNetwork = (MatterNetwork)network;
            matterNetwork.removeElement(this);
        }
        super.leaveNetwork();
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ResourceLocation getNetworkType() {
        return MatterNetwork.MATTER;
    }

    public boolean canConnectFrom(Direction direction) {
        BlockState state = this.level.getBlockState(this.pos);
        Block block = state.getBlock();
        if (block instanceof INetworkDirectionalConnection) {
            INetworkDirectionalConnection networkDirectionalConnection = (INetworkDirectionalConnection)block;
            return networkDirectionalConnection.canConnect(this.level, this.pos, state, direction);
        }
        return true;
    }

    public static class Factory
    implements NetworkElementFactory {
        public NetworkElement createFromNbt(Level level, CompoundTag tag) {
            BlockPos pos = BlockPos.of((long)tag.getLong("pos"));
            DefaultMatterNetworkElement element = new DefaultMatterNetworkElement(level, pos);
            return element;
        }
    }
}

