/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.render;

import com.buuz135.replication.block.tile.ReplicatorBlockEntity;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.calculation.client.ClientReplicationCalculation;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class ReplicatorRenderer
implements BlockEntityRenderer<ReplicatorBlockEntity> {
    private static RenderType AREA_TYPE = ReplicatorRenderer.createRenderType();
    public static BakedModel PLATE = null;

    public static RenderType createRenderType() {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorShader)).setTransparencyState(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).createCompositeState(true);
        return RenderType.create((String)"working_area_render", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
    }

    public void render(ReplicatorBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        MatterCompound matterCompound;
        Direction facing = (Direction)entity.getBlockState().getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        if (facing == Direction.EAST) {
            poseStack.translate(1.0f, 0.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        } else if (facing == Direction.SOUTH) {
            poseStack.translate(1.0f, 0.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
        } else if (facing == Direction.WEST) {
            poseStack.translate(0.0f, 0.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        poseStack.pushPose();
        float[] color = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
        if (!entity.getCraftingStack().isEmpty() && entity.getAction() == 0 && (matterCompound = ClientReplicationCalculation.getMatterCompound(entity.getCraftingStack())) != null) {
            double total = 0.0;
            for (MatterValue matterValue : matterCompound.getValues().values()) {
                total += matterValue.getAmount();
            }
            double currentProgress = (double)((float)entity.getProgress() / (float)entity.getMaxProgress()) * 1.4;
            int progressTotal = 0;
            for (MatterValue matterValue : matterCompound.getValues().values()) {
                if (((double)progressTotal + matterValue.getAmount()) / total >= currentProgress) {
                    color = matterValue.getMatter().getColor().get();
                    break;
                }
                progressTotal = (int)((double)progressTotal + matterValue.getAmount());
            }
        }
        this.renderPlane(poseStack, multiBufferSource, Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)12.0).bounds(), 0.0, 0.15, 0.0, color[0], color[1], color[2], color[3] == 0.0f ? 0.0f : 0.75f);
        this.renderFaces(poseStack, multiBufferSource, Block.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)4.0, (double)12.0).bounds(), 0.0, -0.2, 0.0, 1.0f, 1.0f, 1.0f, 0.005f);
        poseStack.translate(0.0f, -0.563f, 0.0f);
        float progress = ((float)entity.getProgress() + partialTicks / 100.0f) / (float)entity.getMaxProgress();
        poseStack.translate(0.0f, 0.563f * progress - 0.001f, 0.0f);
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(RenderType.solid()), null, PLATE, 255.0f, 255.0f, 255.0f, combinedLightIn, combinedOverlayIn);
        poseStack.translate(0.5f, 0.56f, 0.45f);
        float scale = 0.4f;
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(entity.getCraftingStack(), (Level)Minecraft.getInstance().level, null, 0);
        if (model.isGui3d()) {
            scale = 0.75f;
        }
        poseStack.scale(scale, scale, scale);
        if (entity.getAction() == 0 && !entity.isCurrentTaskAFailure()) {
            Minecraft.getInstance().getItemRenderer().renderStatic(entity.getCraftingStack(), ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, multiBufferSource, entity.getLevel(), 0);
        }
        poseStack.popPose();
    }

    private void renderPlane(PoseStack stack, MultiBufferSource renderTypeBuffer, AABB pos, double x, double y, double z, float red, float green, float blue, float alpha) {
        float x1 = (float)(pos.minX + x);
        float x2 = (float)(pos.maxX + x);
        float y1 = (float)(pos.minY + y);
        float y2 = (float)(pos.maxY + y);
        float z1 = (float)(pos.minZ + z);
        float z2 = (float)(pos.maxZ + z);
        Matrix4f matrix = stack.last().pose();
        VertexConsumer buffer = renderTypeBuffer.getBuffer(AREA_TYPE);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
    }

    private void renderFaces(PoseStack stack, MultiBufferSource renderTypeBuffer, AABB pos, double x, double y, double z, float red, float green, float blue, float alpha) {
        float x1 = (float)(pos.minX + x);
        float x2 = (float)(pos.maxX + x);
        float y1 = (float)(pos.minY + y);
        float y2 = (float)(pos.maxY + y);
        float z1 = (float)(pos.minZ + z);
        float z2 = (float)(pos.maxZ + z);
        Matrix4f matrix = stack.last().pose();
        VertexConsumer buffer = renderTypeBuffer.getBuffer(AREA_TYPE);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
    }
}

