/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.gui.button;

import com.buuz135.replication.ReplicationRegistry;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class ReplicationTerminalConfigButton
extends Button {
    private final ResourceLocation textureRL;
    private final LocatorInstance locatable;
    private final Type type;
    private int state;
    private final int textureX;
    private final int textureY;
    private final int hoveredTextureX;
    private final int hoveredTextureY;

    protected ReplicationTerminalConfigButton(int pX, int pY, int pWidth, int pHeight, ResourceLocation textureRL, LocatorInstance locatable, Type type, int defaultState, int textureX, int textureY, int hoveredTextureX, int hoveredTextureY) {
        super(pX, pY, pWidth, pHeight, (Component)Component.empty(), button -> {}, supplier -> Component.empty());
        this.textureRL = textureRL;
        this.locatable = locatable;
        this.type = type;
        this.state = defaultState;
        this.textureX = textureX;
        this.textureY = textureY;
        this.hoveredTextureX = hoveredTextureX;
        this.hoveredTextureY = hoveredTextureY;
    }

    public void onPress() {
        CompoundTag component = new CompoundTag();
        ++this.state;
        this.state %= this.type.states;
        component.putString("type", this.type.name());
        component.putInt("state", this.state);
        Titanium.NETWORK.sendToServer((Message)new ButtonClickNetworkMessage(this.locatable, 999, component));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.isHovered = pMouseX >= this.getX() && pMouseY >= this.getY() && pMouseX < this.getX() + this.width && pMouseY < this.getY() + this.height;
        guiGraphics.blit(this.textureRL, this.getX(), this.getY(), this.textureX, this.textureY + 9 * this.state, this.getWidth(), this.getHeight());
        if (this.isHovered) {
            guiGraphics.blit(this.textureRL, this.getX(), this.getY(), this.hoveredTextureX, this.hoveredTextureY + 9 * this.state, this.getWidth(), this.getHeight());
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)("tooltip.replication.terminal." + this.type.name().toLowerCase() + ".state_" + this.getState())), pMouseX, pMouseY);
        } else {
            guiGraphics.blit(this.textureRL, this.getX(), this.getY(), this.textureX, this.textureY + 9 * this.state, this.getWidth(), this.getHeight());
        }
        int i = this.getFGColor();
        this.renderString(guiGraphics, Minecraft.getInstance().font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public int getState() {
        return this.state;
    }

    public void playDownSound(SoundManager pHandler) {
        pHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ReplicationRegistry.Sounds.TERMINAL_BUTTON.get()), (float)1.0f));
    }

    public static enum Type {
        SORTING_TYPE(2),
        SORTING_DIRECTION(2),
        MATTEROPEDIA_TYPE(2),
        MATTEROPEDIA_DIRECTION(2);

        private final int states;

        private Type(int states) {
            this.states = states;
        }
    }
}

