/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.api.pattern;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class MatterPattern
implements INBTSerializable<CompoundTag> {
    private ItemStack stack;
    private float completion;

    public MatterPattern() {
        this.stack = ItemStack.EMPTY;
        this.completion = 0.0f;
    }

    public MatterPattern(ItemStack stack, float completion) {
        this.stack = stack;
        this.completion = completion;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public float getCompletion() {
        return this.completion;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public void setCompletion(float completion) {
        this.completion = completion;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("Stack", this.stack.saveOptional(provider));
        compoundTag.putFloat("Completion", this.completion);
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("Stack"));
        this.completion = nbt.getFloat("Completion");
    }

    public String toString() {
        return "MatterPattern{stack=" + String.valueOf(this.stack) + ", completion=" + this.completion + "}";
    }
}

