/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import owmii.powah.block.Blcks;
import owmii.powah.compat.jei.AbstractCategory;
import owmii.powah.compat.jei.Assets;
import owmii.powah.recipe.ReactorFuel;

public class JeiReactorFuelCategory
extends AbstractCategory<Recipe> {
    public static final RecipeType<Recipe> TYPE = RecipeType.create((String)"powah", (String)"reactor_fuel", Recipe.class);

    public JeiReactorFuelCategory(IGuiHelper guiHelper) {
        super(guiHelper, (ItemLike)Blcks.URANINITE.get(), (Component)Component.translatable((String)"gui.powah.jei.category.reactor.fuels"), (IDrawable)guiHelper.drawableBuilder(Assets.MISC, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build());
    }

    public RecipeType<Recipe> getRecipeType() {
        return TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 5).addItemStack(recipe.input());
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        MutableComponent amount = Component.translatable((String)"info.lollipop.amount").append(": ").append((Component)Component.translatable((String)"info.lollipop.mb", (Object[])new Object[]{recipe.reactorFuel.fuelAmount()}));
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.drawString(minecraft.font, (Component)amount, 30, 3, 0x444444, false);
        MutableComponent coloredTemperature = Component.literal((String)String.valueOf(recipe.reactorFuel.temperature())).withStyle(ChatFormatting.DARK_RED);
        MutableComponent temperatureText = Component.translatable((String)"info.lollipop.temperature").append(": ").append((Component)Component.translatable((String)"info.lollipop.temperature.c", (Object[])new Object[]{coloredTemperature}));
        guiGraphics.drawString(minecraft.font, (Component)temperatureText, 30, 15, 0x444444, false);
    }

    public static List<Recipe> createRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (Map.Entry entry : BuiltInRegistries.ITEM.getDataMap(ReactorFuel.DATA_MAP_TYPE).entrySet()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            Item item = (Item)BuiltInRegistries.ITEM.get(key);
            if (item == null) continue;
            recipes.add(new Recipe(item.getDefaultInstance(), key.location(), (ReactorFuel)entry.getValue()));
        }
        return recipes;
    }

    public record Recipe(ItemStack input, ResourceLocation id, ReactorFuel reactorFuel) {
    }
}

