/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.modules.shake;

import it.hurts.octostudios.perception.common.misc.Easing;
import it.hurts.octostudios.perception.common.modules.shake.data.EntityShakeSource;
import it.hurts.octostudios.perception.common.modules.shake.data.PositionShakeSource;
import it.hurts.octostudios.perception.common.modules.shake.data.base.ShakeSource;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Shake {
    private static final Random RANDOM = new Random();
    private ShakeSource source;
    private Function<Float, Float> distanceAmplitudeEasing;
    private Function<Float, Float> distanceSpeedEasing;
    private Function<Float, Float> rotationFadeInEasing;
    private Function<Float, Float> rotationFadeOutEasing;
    private Function<Float, Float> offsetFadeInEasing;
    private Function<Float, Float> offsetFadeOutEasing;
    private Function<Float, Float> fovFadeInEasing;
    private Function<Float, Float> fovFadeOutEasing;
    private Supplier<Float> rangeMultiplier;
    private Supplier<Float> rotationAmplitude;
    private Supplier<Float> offsetAmplitude;
    private Supplier<Float> fovAmplitude;
    private Supplier<Float> rotationSpeed;
    private Supplier<Float> offsetSpeed;
    private Supplier<Float> fovSpeed;
    private Supplier<Integer> duration;
    private Supplier<Integer> fadeInTime;
    private Supplier<Integer> fadeOutTime;
    @Nullable
    private Supplier<Boolean> removeCondition;
    private UUID uuid;
    private final Vec3 frequency = new Vec3((double)(0.8f + RANDOM.nextFloat() * 0.4f), (double)(0.8f + RANDOM.nextFloat() * 0.4f), (double)(0.8f + RANDOM.nextFloat() * 0.4f));
    private final Vector3f lastTickOffset = new Vector3f();
    private final Vector3f currentTickOffset = new Vector3f();
    private final Vector3f lastTickRotation = new Vector3f();
    private final Vector3f currentTickRotation = new Vector3f();
    private int elapsedTime;

    public static ShakeBuilder builder(ShakeSource source) {
        ShakeBuilder builder = new ShakeBuilder();
        builder.source(source);
        return builder;
    }

    public static ShakeBuilder builder(Entity entity) {
        return Shake.builder(new EntityShakeSource(entity));
    }

    public static ShakeBuilder builder(Vec3 position) {
        return Shake.builder(new PositionShakeSource(position));
    }

    public boolean isFinished() {
        return this.removeCondition == null ? this.elapsedTime >= this.getDuration() : this.getRemoveCondition();
    }

    public void update(Player player) {
        ++this.elapsedTime;
        this.lastTickOffset.set((Vector3fc)this.currentTickOffset);
        this.lastTickRotation.set((Vector3fc)this.currentTickRotation);
        float currentTime = (float)this.elapsedTime / 20.0f;
        float rotationAmplitude = this.getCumulativeRotationAmplitude(player);
        float rotationSpeed = this.getCumulativeRotationSpeed(player);
        if (rotationAmplitude > 0.0f && rotationSpeed > 0.0f) {
            this.currentTickRotation.set((Vector3fc)this.computeRotationForTick(player, rotationAmplitude, rotationSpeed, currentTime));
        } else {
            this.currentTickRotation.set(0.0f, 0.0f, 0.0f);
            this.lastTickRotation.set(0.0f, 0.0f, 0.0f);
        }
        float offsetAmplitude = this.getCumulativeOffsetAmplitude(player);
        float offsetSpeed = this.getCumulativeOffsetSpeed(player);
        if (offsetAmplitude > 0.0f && offsetSpeed > 0.0f) {
            this.currentTickOffset.set((Vector3fc)this.computeOffsetForTick(player, offsetAmplitude, offsetSpeed, currentTime));
        } else {
            this.currentTickOffset.set(0.0f, 0.0f, 0.0f);
            this.lastTickOffset.set(0.0f, 0.0f, 0.0f);
        }
    }

    public Vector3f getShakeOffset(Player player, float partialTicks) {
        float x = Mth.lerp((float)partialTicks, (float)this.lastTickOffset.x(), (float)this.currentTickOffset.x());
        float y = Mth.lerp((float)partialTicks, (float)this.lastTickOffset.y(), (float)this.currentTickOffset.y());
        float z = Mth.lerp((float)partialTicks, (float)this.lastTickOffset.z(), (float)this.currentTickOffset.z());
        return new Vector3f(x, y, z);
    }

    public Vector3f getShakeRotation(Player player, float partialTicks) {
        float x = Mth.lerp((float)partialTicks, (float)this.lastTickRotation.x(), (float)this.currentTickRotation.x());
        float y = Mth.lerp((float)partialTicks, (float)this.lastTickRotation.y(), (float)this.currentTickRotation.y());
        float z = Mth.lerp((float)partialTicks, (float)this.lastTickRotation.z(), (float)this.currentTickRotation.z());
        return new Vector3f(x, y, z);
    }

    public float getShakeFOV(Player player, float partialTicks) {
        return this.getCumulativeFovAmplitude(player);
    }

    private Vector3f computeOffsetForTick(Player player, float amplitude, float speed, float currentTime) {
        float wave = (float)Math.sin(Math.PI * 2 * (double)speed * (double)currentTime);
        Vec3 direction = player.getEyePosition().subtract(this.source.getPos()).normalize();
        float verticalMultiplier = 1.0f;
        float offsetX = (float)(direction.x * (double)amplitude * (double)wave);
        float offsetY = (float)(direction.y * (double)amplitude * (double)wave * (double)verticalMultiplier);
        float offsetZ = (float)(direction.z * (double)amplitude * (double)wave);
        return new Vector3f(offsetX, offsetY, offsetZ);
    }

    private Vector3f computeRotationForTick(Player player, float amplitude, float speed, float currentTime) {
        Vec3 playerView = player.getLookAngle();
        float pitchFactor = (float)playerView.dot(new Vec3(0.0, 1.0, 0.0));
        float yawFactor = (float)playerView.cross(new Vec3(0.0, 1.0, 0.0)).dot(this.source.getPos().subtract(player.position()).normalize());
        float angleX = (float)Math.sin(Math.PI * 2 * (double)speed * this.frequency.x() * (double)currentTime) * amplitude * pitchFactor;
        float angleY = (float)Math.sin(Math.PI * 2 * (double)speed * this.frequency.y() * (double)currentTime) * amplitude * yawFactor;
        float angleZ = (float)Math.sin(Math.PI * 2 * (double)speed * this.frequency.z() * (double)currentTime) * amplitude;
        return new Vector3f(angleX, angleY, angleZ);
    }

    private float getCumulativeAmplitude(Player player, float amplitude, Function<Float, Float> fadeInEasing, Function<Float, Float> fadeOutEasing) {
        float timeFactor;
        float distance = (float)player.position().distanceTo(this.source.getPos());
        int duration = this.getDuration();
        float radius = this.getRangeMultiplier();
        int fadeInTime = this.getFadeInTime();
        int fadeOutTime = this.getFadeOutTime();
        if (distance > radius) {
            return 0.0f;
        }
        Float distanceFactor = this.distanceAmplitudeEasing.apply(Float.valueOf(Mth.clamp((float)(1.0f - distance / radius), (float)0.0f, (float)1.0f)));
        if (this.elapsedTime < fadeInTime) {
            float progress = (float)this.elapsedTime / (float)fadeInTime;
            timeFactor = fadeInEasing.apply(Float.valueOf(progress)).floatValue();
        } else if (this.elapsedTime > duration - fadeOutTime) {
            float progress = (float)(duration - this.elapsedTime) / (float)fadeOutTime;
            timeFactor = fadeOutEasing.apply(Float.valueOf(progress)).floatValue();
        } else {
            timeFactor = 1.0f;
        }
        return amplitude * distanceFactor.floatValue() * timeFactor;
    }

    public float getCumulativeRotationAmplitude(Player player) {
        return this.getCumulativeAmplitude(player, this.getRotationAmplitude(), this.rotationFadeInEasing, this.rotationFadeOutEasing);
    }

    public float getCumulativeOffsetAmplitude(Player player) {
        return this.getCumulativeAmplitude(player, this.getOffsetAmplitude(), this.offsetFadeInEasing, this.offsetFadeOutEasing);
    }

    public float getCumulativeFovAmplitude(Player player) {
        return this.getCumulativeAmplitude(player, this.getFovAmplitude(), this.fovFadeInEasing, this.fovFadeOutEasing);
    }

    public float getCumulativeRotationSpeed(Player player) {
        return this.getCumulativeSpeed(player, this.getRotationSpeed());
    }

    public float getCumulativeOffsetSpeed(Player player) {
        return this.getCumulativeSpeed(player, this.getOffsetSpeed());
    }

    public float getCumulativeFovSpeed(Player player) {
        return this.getCumulativeSpeed(player, this.getFovSpeed());
    }

    private float getCumulativeSpeed(Player player, float speed) {
        float radius;
        float distance = (float)player.position().distanceTo(this.source.getPos());
        if (distance > (radius = this.getRangeMultiplier())) {
            return 0.0f;
        }
        Float distanceFactor = this.distanceSpeedEasing.apply(Float.valueOf(Mth.clamp((float)(1.0f - distance / radius), (float)0.0f, (float)1.0f)));
        return speed * distanceFactor.floatValue();
    }

    public float getRangeMultiplier() {
        return this.rangeMultiplier.get().floatValue();
    }

    public float getRotationAmplitude() {
        return this.rotationAmplitude.get().floatValue();
    }

    public float getOffsetAmplitude() {
        return this.offsetAmplitude.get().floatValue();
    }

    public float getFovAmplitude() {
        return this.fovAmplitude.get().floatValue();
    }

    public float getRotationSpeed() {
        return this.rotationSpeed.get().floatValue();
    }

    public float getOffsetSpeed() {
        return this.offsetSpeed.get().floatValue();
    }

    public float getFovSpeed() {
        return this.fovSpeed.get().floatValue();
    }

    public int getDuration() {
        return this.duration.get();
    }

    public int getFadeInTime() {
        return this.fadeInTime.get();
    }

    public int getFadeOutTime() {
        return this.fadeOutTime.get() == -1 ? this.getDuration() - this.getFadeInTime() : this.fadeOutTime.get();
    }

    public boolean getRemoveCondition() {
        return this.removeCondition == null || this.removeCondition.get() != false;
    }

    private static Supplier<Boolean> $default$removeCondition() {
        return null;
    }

    private static UUID $default$uuid() {
        return UUID.randomUUID();
    }

    Shake(ShakeSource source, Function<Float, Float> distanceAmplitudeEasing, Function<Float, Float> distanceSpeedEasing, Function<Float, Float> rotationFadeInEasing, Function<Float, Float> rotationFadeOutEasing, Function<Float, Float> offsetFadeInEasing, Function<Float, Float> offsetFadeOutEasing, Function<Float, Float> fovFadeInEasing, Function<Float, Float> fovFadeOutEasing, Supplier<Float> rangeMultiplier, Supplier<Float> rotationAmplitude, Supplier<Float> offsetAmplitude, Supplier<Float> fovAmplitude, Supplier<Float> rotationSpeed, Supplier<Float> offsetSpeed, Supplier<Float> fovSpeed, Supplier<Integer> duration, Supplier<Integer> fadeInTime, Supplier<Integer> fadeOutTime, @Nullable Supplier<Boolean> removeCondition, UUID uuid, int elapsedTime) {
        this.source = source;
        this.distanceAmplitudeEasing = distanceAmplitudeEasing;
        this.distanceSpeedEasing = distanceSpeedEasing;
        this.rotationFadeInEasing = rotationFadeInEasing;
        this.rotationFadeOutEasing = rotationFadeOutEasing;
        this.offsetFadeInEasing = offsetFadeInEasing;
        this.offsetFadeOutEasing = offsetFadeOutEasing;
        this.fovFadeInEasing = fovFadeInEasing;
        this.fovFadeOutEasing = fovFadeOutEasing;
        this.rangeMultiplier = rangeMultiplier;
        this.rotationAmplitude = rotationAmplitude;
        this.offsetAmplitude = offsetAmplitude;
        this.fovAmplitude = fovAmplitude;
        this.rotationSpeed = rotationSpeed;
        this.offsetSpeed = offsetSpeed;
        this.fovSpeed = fovSpeed;
        this.duration = duration;
        this.fadeInTime = fadeInTime;
        this.fadeOutTime = fadeOutTime;
        this.removeCondition = removeCondition;
        this.uuid = uuid;
        this.elapsedTime = elapsedTime;
    }

    public ShakeSource getSource() {
        return this.source;
    }

    public Function<Float, Float> getDistanceAmplitudeEasing() {
        return this.distanceAmplitudeEasing;
    }

    public Function<Float, Float> getDistanceSpeedEasing() {
        return this.distanceSpeedEasing;
    }

    public Function<Float, Float> getRotationFadeInEasing() {
        return this.rotationFadeInEasing;
    }

    public Function<Float, Float> getRotationFadeOutEasing() {
        return this.rotationFadeOutEasing;
    }

    public Function<Float, Float> getOffsetFadeInEasing() {
        return this.offsetFadeInEasing;
    }

    public Function<Float, Float> getOffsetFadeOutEasing() {
        return this.offsetFadeOutEasing;
    }

    public Function<Float, Float> getFovFadeInEasing() {
        return this.fovFadeInEasing;
    }

    public Function<Float, Float> getFovFadeOutEasing() {
        return this.fovFadeOutEasing;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Vec3 getFrequency() {
        return this.frequency;
    }

    public Vector3f getLastTickOffset() {
        return this.lastTickOffset;
    }

    public Vector3f getCurrentTickOffset() {
        return this.currentTickOffset;
    }

    public Vector3f getLastTickRotation() {
        return this.lastTickRotation;
    }

    public Vector3f getCurrentTickRotation() {
        return this.currentTickRotation;
    }

    public int getElapsedTime() {
        return this.elapsedTime;
    }

    public void setSource(ShakeSource source) {
        this.source = source;
    }

    public void setDistanceAmplitudeEasing(Function<Float, Float> distanceAmplitudeEasing) {
        this.distanceAmplitudeEasing = distanceAmplitudeEasing;
    }

    public void setDistanceSpeedEasing(Function<Float, Float> distanceSpeedEasing) {
        this.distanceSpeedEasing = distanceSpeedEasing;
    }

    public void setRotationFadeInEasing(Function<Float, Float> rotationFadeInEasing) {
        this.rotationFadeInEasing = rotationFadeInEasing;
    }

    public void setRotationFadeOutEasing(Function<Float, Float> rotationFadeOutEasing) {
        this.rotationFadeOutEasing = rotationFadeOutEasing;
    }

    public void setOffsetFadeInEasing(Function<Float, Float> offsetFadeInEasing) {
        this.offsetFadeInEasing = offsetFadeInEasing;
    }

    public void setOffsetFadeOutEasing(Function<Float, Float> offsetFadeOutEasing) {
        this.offsetFadeOutEasing = offsetFadeOutEasing;
    }

    public void setFovFadeInEasing(Function<Float, Float> fovFadeInEasing) {
        this.fovFadeInEasing = fovFadeInEasing;
    }

    public void setFovFadeOutEasing(Function<Float, Float> fovFadeOutEasing) {
        this.fovFadeOutEasing = fovFadeOutEasing;
    }

    public void setRangeMultiplier(Supplier<Float> rangeMultiplier) {
        this.rangeMultiplier = rangeMultiplier;
    }

    public void setRotationAmplitude(Supplier<Float> rotationAmplitude) {
        this.rotationAmplitude = rotationAmplitude;
    }

    public void setOffsetAmplitude(Supplier<Float> offsetAmplitude) {
        this.offsetAmplitude = offsetAmplitude;
    }

    public void setFovAmplitude(Supplier<Float> fovAmplitude) {
        this.fovAmplitude = fovAmplitude;
    }

    public void setRotationSpeed(Supplier<Float> rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
    }

    public void setOffsetSpeed(Supplier<Float> offsetSpeed) {
        this.offsetSpeed = offsetSpeed;
    }

    public void setFovSpeed(Supplier<Float> fovSpeed) {
        this.fovSpeed = fovSpeed;
    }

    public void setDuration(Supplier<Integer> duration) {
        this.duration = duration;
    }

    public void setFadeInTime(Supplier<Integer> fadeInTime) {
        this.fadeInTime = fadeInTime;
    }

    public void setFadeOutTime(Supplier<Integer> fadeOutTime) {
        this.fadeOutTime = fadeOutTime;
    }

    public void setRemoveCondition(@Nullable Supplier<Boolean> removeCondition) {
        this.removeCondition = removeCondition;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setElapsedTime(int elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Shake)) {
            return false;
        }
        Shake other = (Shake)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getElapsedTime() != other.getElapsedTime()) {
            return false;
        }
        ShakeSource this$source = this.getSource();
        ShakeSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        Function<Float, Float> this$distanceAmplitudeEasing = this.getDistanceAmplitudeEasing();
        Function<Float, Float> other$distanceAmplitudeEasing = other.getDistanceAmplitudeEasing();
        if (this$distanceAmplitudeEasing == null ? other$distanceAmplitudeEasing != null : !this$distanceAmplitudeEasing.equals(other$distanceAmplitudeEasing)) {
            return false;
        }
        Function<Float, Float> this$distanceSpeedEasing = this.getDistanceSpeedEasing();
        Function<Float, Float> other$distanceSpeedEasing = other.getDistanceSpeedEasing();
        if (this$distanceSpeedEasing == null ? other$distanceSpeedEasing != null : !this$distanceSpeedEasing.equals(other$distanceSpeedEasing)) {
            return false;
        }
        Function<Float, Float> this$rotationFadeInEasing = this.getRotationFadeInEasing();
        Function<Float, Float> other$rotationFadeInEasing = other.getRotationFadeInEasing();
        if (this$rotationFadeInEasing == null ? other$rotationFadeInEasing != null : !this$rotationFadeInEasing.equals(other$rotationFadeInEasing)) {
            return false;
        }
        Function<Float, Float> this$rotationFadeOutEasing = this.getRotationFadeOutEasing();
        Function<Float, Float> other$rotationFadeOutEasing = other.getRotationFadeOutEasing();
        if (this$rotationFadeOutEasing == null ? other$rotationFadeOutEasing != null : !this$rotationFadeOutEasing.equals(other$rotationFadeOutEasing)) {
            return false;
        }
        Function<Float, Float> this$offsetFadeInEasing = this.getOffsetFadeInEasing();
        Function<Float, Float> other$offsetFadeInEasing = other.getOffsetFadeInEasing();
        if (this$offsetFadeInEasing == null ? other$offsetFadeInEasing != null : !this$offsetFadeInEasing.equals(other$offsetFadeInEasing)) {
            return false;
        }
        Function<Float, Float> this$offsetFadeOutEasing = this.getOffsetFadeOutEasing();
        Function<Float, Float> other$offsetFadeOutEasing = other.getOffsetFadeOutEasing();
        if (this$offsetFadeOutEasing == null ? other$offsetFadeOutEasing != null : !this$offsetFadeOutEasing.equals(other$offsetFadeOutEasing)) {
            return false;
        }
        Function<Float, Float> this$fovFadeInEasing = this.getFovFadeInEasing();
        Function<Float, Float> other$fovFadeInEasing = other.getFovFadeInEasing();
        if (this$fovFadeInEasing == null ? other$fovFadeInEasing != null : !this$fovFadeInEasing.equals(other$fovFadeInEasing)) {
            return false;
        }
        Function<Float, Float> this$fovFadeOutEasing = this.getFovFadeOutEasing();
        Function<Float, Float> other$fovFadeOutEasing = other.getFovFadeOutEasing();
        if (this$fovFadeOutEasing == null ? other$fovFadeOutEasing != null : !this$fovFadeOutEasing.equals(other$fovFadeOutEasing)) {
            return false;
        }
        if (Float.compare(this.getRangeMultiplier(), other.getRangeMultiplier()) != 0) {
            return false;
        }
        if (Float.compare(this.getRotationAmplitude(), other.getRotationAmplitude()) != 0) {
            return false;
        }
        if (Float.compare(this.getOffsetAmplitude(), other.getOffsetAmplitude()) != 0) {
            return false;
        }
        if (Float.compare(this.getFovAmplitude(), other.getFovAmplitude()) != 0) {
            return false;
        }
        if (Float.compare(this.getRotationSpeed(), other.getRotationSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getOffsetSpeed(), other.getOffsetSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getFovSpeed(), other.getFovSpeed()) != 0) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getFadeInTime() != other.getFadeInTime()) {
            return false;
        }
        if (this.getFadeOutTime() != other.getFadeOutTime()) {
            return false;
        }
        if (this.getRemoveCondition() != other.getRemoveCondition()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        Vec3 this$frequency = this.getFrequency();
        Vec3 other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !this$frequency.equals(other$frequency)) {
            return false;
        }
        Vector3f this$lastTickOffset = this.getLastTickOffset();
        Vector3f other$lastTickOffset = other.getLastTickOffset();
        if (this$lastTickOffset == null ? other$lastTickOffset != null : !this$lastTickOffset.equals(other$lastTickOffset)) {
            return false;
        }
        Vector3f this$currentTickOffset = this.getCurrentTickOffset();
        Vector3f other$currentTickOffset = other.getCurrentTickOffset();
        if (this$currentTickOffset == null ? other$currentTickOffset != null : !this$currentTickOffset.equals(other$currentTickOffset)) {
            return false;
        }
        Vector3f this$lastTickRotation = this.getLastTickRotation();
        Vector3f other$lastTickRotation = other.getLastTickRotation();
        if (this$lastTickRotation == null ? other$lastTickRotation != null : !this$lastTickRotation.equals(other$lastTickRotation)) {
            return false;
        }
        Vector3f this$currentTickRotation = this.getCurrentTickRotation();
        Vector3f other$currentTickRotation = other.getCurrentTickRotation();
        return !(this$currentTickRotation == null ? other$currentTickRotation != null : !this$currentTickRotation.equals(other$currentTickRotation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Shake;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getElapsedTime();
        ShakeSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        Function<Float, Float> $distanceAmplitudeEasing = this.getDistanceAmplitudeEasing();
        result = result * 59 + ($distanceAmplitudeEasing == null ? 43 : $distanceAmplitudeEasing.hashCode());
        Function<Float, Float> $distanceSpeedEasing = this.getDistanceSpeedEasing();
        result = result * 59 + ($distanceSpeedEasing == null ? 43 : $distanceSpeedEasing.hashCode());
        Function<Float, Float> $rotationFadeInEasing = this.getRotationFadeInEasing();
        result = result * 59 + ($rotationFadeInEasing == null ? 43 : $rotationFadeInEasing.hashCode());
        Function<Float, Float> $rotationFadeOutEasing = this.getRotationFadeOutEasing();
        result = result * 59 + ($rotationFadeOutEasing == null ? 43 : $rotationFadeOutEasing.hashCode());
        Function<Float, Float> $offsetFadeInEasing = this.getOffsetFadeInEasing();
        result = result * 59 + ($offsetFadeInEasing == null ? 43 : $offsetFadeInEasing.hashCode());
        Function<Float, Float> $offsetFadeOutEasing = this.getOffsetFadeOutEasing();
        result = result * 59 + ($offsetFadeOutEasing == null ? 43 : $offsetFadeOutEasing.hashCode());
        Function<Float, Float> $fovFadeInEasing = this.getFovFadeInEasing();
        result = result * 59 + ($fovFadeInEasing == null ? 43 : $fovFadeInEasing.hashCode());
        Function<Float, Float> $fovFadeOutEasing = this.getFovFadeOutEasing();
        result = result * 59 + ($fovFadeOutEasing == null ? 43 : $fovFadeOutEasing.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getRangeMultiplier());
        result = result * 59 + Float.floatToIntBits(this.getRotationAmplitude());
        result = result * 59 + Float.floatToIntBits(this.getOffsetAmplitude());
        result = result * 59 + Float.floatToIntBits(this.getFovAmplitude());
        result = result * 59 + Float.floatToIntBits(this.getRotationSpeed());
        result = result * 59 + Float.floatToIntBits(this.getOffsetSpeed());
        result = result * 59 + Float.floatToIntBits(this.getFovSpeed());
        result = result * 59 + this.getDuration();
        result = result * 59 + this.getFadeInTime();
        result = result * 59 + this.getFadeOutTime();
        result = result * 59 + (this.getRemoveCondition() ? 79 : 97);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        Vec3 $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : $frequency.hashCode());
        Vector3f $lastTickOffset = this.getLastTickOffset();
        result = result * 59 + ($lastTickOffset == null ? 43 : $lastTickOffset.hashCode());
        Vector3f $currentTickOffset = this.getCurrentTickOffset();
        result = result * 59 + ($currentTickOffset == null ? 43 : $currentTickOffset.hashCode());
        Vector3f $lastTickRotation = this.getLastTickRotation();
        result = result * 59 + ($lastTickRotation == null ? 43 : $lastTickRotation.hashCode());
        Vector3f $currentTickRotation = this.getCurrentTickRotation();
        result = result * 59 + ($currentTickRotation == null ? 43 : $currentTickRotation.hashCode());
        return result;
    }

    public String toString() {
        return "Shake(source=" + String.valueOf(this.getSource()) + ", distanceAmplitudeEasing=" + String.valueOf(this.getDistanceAmplitudeEasing()) + ", distanceSpeedEasing=" + String.valueOf(this.getDistanceSpeedEasing()) + ", rotationFadeInEasing=" + String.valueOf(this.getRotationFadeInEasing()) + ", rotationFadeOutEasing=" + String.valueOf(this.getRotationFadeOutEasing()) + ", offsetFadeInEasing=" + String.valueOf(this.getOffsetFadeInEasing()) + ", offsetFadeOutEasing=" + String.valueOf(this.getOffsetFadeOutEasing()) + ", fovFadeInEasing=" + String.valueOf(this.getFovFadeInEasing()) + ", fovFadeOutEasing=" + String.valueOf(this.getFovFadeOutEasing()) + ", rangeMultiplier=" + this.getRangeMultiplier() + ", rotationAmplitude=" + this.getRotationAmplitude() + ", offsetAmplitude=" + this.getOffsetAmplitude() + ", fovAmplitude=" + this.getFovAmplitude() + ", rotationSpeed=" + this.getRotationSpeed() + ", offsetSpeed=" + this.getOffsetSpeed() + ", fovSpeed=" + this.getFovSpeed() + ", duration=" + this.getDuration() + ", fadeInTime=" + this.getFadeInTime() + ", fadeOutTime=" + this.getFadeOutTime() + ", removeCondition=" + this.getRemoveCondition() + ", uuid=" + String.valueOf(this.getUuid()) + ", frequency=" + String.valueOf(this.getFrequency()) + ", lastTickOffset=" + String.valueOf(this.getLastTickOffset()) + ", currentTickOffset=" + String.valueOf(this.getCurrentTickOffset()) + ", lastTickRotation=" + String.valueOf(this.getLastTickRotation()) + ", currentTickRotation=" + String.valueOf(this.getCurrentTickRotation()) + ", elapsedTime=" + this.getElapsedTime() + ")";
    }

    public static class ShakeBuilder {
        private ShakeSource source;
        private boolean removeCondition$set;
        private Supplier<Boolean> removeCondition$value;
        private boolean uuid$set;
        private UUID uuid$value;
        private int elapsedTime;
        private Supplier<Float> rangeMultiplier = () -> Float.valueOf(1.0f);
        private Supplier<Float> rotationAmplitude = () -> Float.valueOf(1.0f);
        private Supplier<Float> offsetAmplitude = () -> Float.valueOf(1.0f);
        private Supplier<Float> fovAmplitude = () -> Float.valueOf(1.0f);
        private Supplier<Float> rotationSpeed = () -> Float.valueOf(5.0f);
        private Supplier<Float> offsetSpeed = () -> Float.valueOf(5.0f);
        private Supplier<Float> fovSpeed = () -> Float.valueOf(5.0f);
        private Supplier<Integer> duration = () -> 20;
        private Supplier<Integer> fadeInTime = () -> 0;
        private Supplier<Integer> fadeOutTime = () -> -1;
        private Function<Float, Float> distanceAmplitudeEasing = Easing::easeOutCubic;
        private Function<Float, Float> distanceSpeedEasing = Easing::easeOutQuad;
        private Function<Float, Float> rotationFadeInEasing = Easing::linear;
        private Function<Float, Float> rotationFadeOutEasing = Easing::linear;
        private Function<Float, Float> offsetFadeInEasing = Easing::linear;
        private Function<Float, Float> offsetFadeOutEasing = Easing::linear;
        private Function<Float, Float> fovFadeInEasing = Easing::linear;
        private Function<Float, Float> fovFadeOutEasing = Easing::linear;

        public ShakeBuilder rangeMultiplier(Supplier<Float> radius) {
            this.rangeMultiplier = radius;
            return this;
        }

        public ShakeBuilder amplitude(Supplier<Float> rotationAmplitude, Supplier<Float> offsetAmplitude, Supplier<Float> fovAmplitude) {
            this.rotationAmplitude = rotationAmplitude;
            this.offsetAmplitude = offsetAmplitude;
            this.fovAmplitude = fovAmplitude;
            return this;
        }

        public ShakeBuilder amplitude(Supplier<Float> amplitude) {
            return this.amplitude(amplitude, amplitude, amplitude);
        }

        public ShakeBuilder rotationAmplitude(Supplier<Float> amplitude) {
            this.rotationAmplitude = amplitude;
            return this;
        }

        public ShakeBuilder offsetAmplitude(Supplier<Float> amplitude) {
            this.offsetAmplitude = amplitude;
            return this;
        }

        public ShakeBuilder fovAmplitude(Supplier<Float> amplitude) {
            this.fovAmplitude = amplitude;
            return this;
        }

        public ShakeBuilder speed(Supplier<Float> rotationSpeed, Supplier<Float> offsetSpeed, Supplier<Float> fovSpeed) {
            this.rotationSpeed = rotationSpeed;
            this.offsetSpeed = offsetSpeed;
            this.fovSpeed = fovSpeed;
            return this;
        }

        public ShakeBuilder speed(Supplier<Float> speed) {
            return this.speed(speed, speed, speed);
        }

        public ShakeBuilder rotationSpeed(Supplier<Float> speed) {
            this.rotationSpeed = speed;
            return this;
        }

        public ShakeBuilder offsetSpeed(Supplier<Float> speed) {
            this.offsetSpeed = speed;
            return this;
        }

        public ShakeBuilder fovSpeed(Supplier<Float> speed) {
            this.fovSpeed = speed;
            return this;
        }

        public ShakeBuilder duration(Supplier<Integer> duration) {
            this.duration = duration;
            return this;
        }

        public ShakeBuilder fadeInTime(Supplier<Integer> fadeInTime) {
            this.fadeInTime = fadeInTime;
            return this;
        }

        public ShakeBuilder fadeOutTime(Supplier<Integer> fadeOutTime) {
            this.fadeOutTime = fadeOutTime;
            return this;
        }

        public ShakeBuilder distanceAmplitudeEasing(Function<Float, Float> distanceAmplitudeEasing) {
            this.distanceAmplitudeEasing = distanceAmplitudeEasing;
            return this;
        }

        public ShakeBuilder distanceSpeedEasing(Function<Float, Float> distanceSpeedEasing) {
            this.distanceSpeedEasing = distanceSpeedEasing;
            return this;
        }

        public ShakeBuilder rotationFadeInEasing(Function<Float, Float> rotationFadeInEasing) {
            this.rotationFadeInEasing = rotationFadeInEasing;
            return this;
        }

        public ShakeBuilder rotationFadeOutEasing(Function<Float, Float> rotationFadeOutEasing) {
            this.rotationFadeOutEasing = rotationFadeOutEasing;
            return this;
        }

        public ShakeBuilder offsetFadeInEasing(Function<Float, Float> offsetFadeInEasing) {
            this.offsetFadeInEasing = offsetFadeInEasing;
            return this;
        }

        public ShakeBuilder offsetFadeOutEasing(Function<Float, Float> offsetFadeOutEasing) {
            this.offsetFadeOutEasing = offsetFadeOutEasing;
            return this;
        }

        public ShakeBuilder fovFadeInEasing(Function<Float, Float> fovFadeInEasing) {
            this.fovFadeInEasing = fovFadeInEasing;
            return this;
        }

        public ShakeBuilder fovFadeOutEasing(Function<Float, Float> fovFadeOutEasing) {
            this.fovFadeOutEasing = fovFadeOutEasing;
            return this;
        }

        private ShakeBuilder source(ShakeSource source) {
            this.source = source;
            return this;
        }

        public ShakeBuilder rangeMultiplier(float rangeMultiplier) {
            this.rangeMultiplier = () -> Float.valueOf(rangeMultiplier);
            return this;
        }

        public ShakeBuilder amplitude(float rotationAmplitude, float offsetAmplitude, float fovAmplitude) {
            return this.amplitude(() -> Float.valueOf(rotationAmplitude), () -> Float.valueOf(offsetAmplitude), () -> Float.valueOf(fovAmplitude));
        }

        public ShakeBuilder amplitude(float amplitude) {
            return this.amplitude(amplitude, amplitude, amplitude);
        }

        public ShakeBuilder rotationAmplitude(float amplitude) {
            return this.rotationAmplitude(() -> Float.valueOf(amplitude));
        }

        public ShakeBuilder offsetAmplitude(float amplitude) {
            return this.offsetAmplitude(() -> Float.valueOf(amplitude));
        }

        public ShakeBuilder fovAmplitude(float amplitude) {
            return this.fovAmplitude(() -> Float.valueOf(amplitude));
        }

        public ShakeBuilder speed(float rotationSpeed, float offsetSpeed, float fovSpeed) {
            return this.speed(() -> Float.valueOf(rotationSpeed), () -> Float.valueOf(offsetSpeed), () -> Float.valueOf(fovSpeed));
        }

        public ShakeBuilder speed(float speed) {
            return this.speed(speed, speed, speed);
        }

        public ShakeBuilder rotationSpeed(float speed) {
            return this.rotationSpeed(() -> Float.valueOf(speed));
        }

        public ShakeBuilder offsetSpeed(float speed) {
            return this.offsetSpeed(() -> Float.valueOf(speed));
        }

        public ShakeBuilder fovSpeed(float speed) {
            return this.fovSpeed(() -> Float.valueOf(speed));
        }

        public ShakeBuilder duration(int duration) {
            this.duration = () -> duration;
            return this;
        }

        public ShakeBuilder fadeInTime(int fadeInTime) {
            this.fadeInTime = () -> fadeInTime;
            return this;
        }

        public ShakeBuilder fadeOutTime(int fadeOutTime) {
            this.fadeOutTime = () -> fadeOutTime;
            return this;
        }

        private ShakeBuilder elapsedTime(int elapsedTime) {
            return this;
        }

        ShakeBuilder() {
        }

        public ShakeBuilder removeCondition(@Nullable Supplier<Boolean> removeCondition) {
            this.removeCondition$value = removeCondition;
            this.removeCondition$set = true;
            return this;
        }

        public ShakeBuilder uuid(UUID uuid) {
            this.uuid$value = uuid;
            this.uuid$set = true;
            return this;
        }

        public Shake build() {
            Supplier<Boolean> removeCondition$value = this.removeCondition$value;
            if (!this.removeCondition$set) {
                removeCondition$value = Shake.$default$removeCondition();
            }
            UUID uuid$value = this.uuid$value;
            if (!this.uuid$set) {
                uuid$value = Shake.$default$uuid();
            }
            return new Shake(this.source, this.distanceAmplitudeEasing, this.distanceSpeedEasing, this.rotationFadeInEasing, this.rotationFadeOutEasing, this.offsetFadeInEasing, this.offsetFadeOutEasing, this.fovFadeInEasing, this.fovFadeOutEasing, this.rangeMultiplier, this.rotationAmplitude, this.offsetAmplitude, this.fovAmplitude, this.rotationSpeed, this.offsetSpeed, this.fovSpeed, this.duration, this.fadeInTime, this.fadeOutTime, removeCondition$value, uuid$value, this.elapsedTime);
        }

        public String toString() {
            return "Shake.ShakeBuilder(source=" + String.valueOf(this.source) + ", distanceAmplitudeEasing=" + String.valueOf(this.distanceAmplitudeEasing) + ", distanceSpeedEasing=" + String.valueOf(this.distanceSpeedEasing) + ", rotationFadeInEasing=" + String.valueOf(this.rotationFadeInEasing) + ", rotationFadeOutEasing=" + String.valueOf(this.rotationFadeOutEasing) + ", offsetFadeInEasing=" + String.valueOf(this.offsetFadeInEasing) + ", offsetFadeOutEasing=" + String.valueOf(this.offsetFadeOutEasing) + ", fovFadeInEasing=" + String.valueOf(this.fovFadeInEasing) + ", fovFadeOutEasing=" + String.valueOf(this.fovFadeOutEasing) + ", rangeMultiplier=" + String.valueOf(this.rangeMultiplier) + ", rotationAmplitude=" + String.valueOf(this.rotationAmplitude) + ", offsetAmplitude=" + String.valueOf(this.offsetAmplitude) + ", fovAmplitude=" + String.valueOf(this.fovAmplitude) + ", rotationSpeed=" + String.valueOf(this.rotationSpeed) + ", offsetSpeed=" + String.valueOf(this.offsetSpeed) + ", fovSpeed=" + String.valueOf(this.fovSpeed) + ", duration=" + String.valueOf(this.duration) + ", fadeInTime=" + String.valueOf(this.fadeInTime) + ", fadeOutTime=" + String.valueOf(this.fadeOutTime) + ", removeCondition$value=" + String.valueOf(this.removeCondition$value) + ", uuid$value=" + String.valueOf(this.uuid$value) + ", elapsedTime=" + this.elapsedTime + ")";
        }
    }
}

