/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.common.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.ServiceLoader;
import net.darkhax.openloader.common.impl.OpenLoader;

public interface Platform {
    public static final Platform PLATFORM = Platform.load(Platform.class);

    public Path getGamePath();

    default public File getGameDirectory() {
        return this.getGamePath().toFile();
    }

    public Path getConfigPath();

    default public File getConfigDirectory() {
        return this.getConfigPath().toFile();
    }

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        OpenLoader.LOG.debug("Loaded {} for service {}.", loadedService, clazz);
        return loadedService;
    }
}

