/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.entities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.component.BWGDataComponents;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import net.potionstudios.biomeswevegone.world.level.block.custom.PumpkinBurrowBlock;
import net.potionstudios.biomeswevegone.world.level.block.entities.BWGBlockEntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PumpkinBurrowBlockEntity
extends BlockEntity {
    private static final List<String> IGNORED_TAGS = List.of("Air", "ArmorDropChances", "ArmorItems", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "Hiding", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "OnGround", "PortalCooldown", "Pos", "Rotation", "UUID");
    private Occupant stored = Occupant.EMPTY;

    public PumpkinBurrowBlockEntity(BlockPos pos, BlockState blockState) {
        super(BWGBlockEntityType.PUMPKIN_BURROW.get(), pos, blockState);
    }

    public void addOccupant(LivingEntity occupant) {
        if (this.isEmpty()) {
            occupant.stopRiding();
            occupant.ejectPassengers();
            occupant.setSleepingPos(this.getBlockPos());
            this.stored = Occupant.of((Entity)occupant);
            occupant.discard();
            if (this.getLevel() != null) {
                this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)PumpkinBurrowBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)));
            }
            super.setChanged();
        }
    }

    public boolean isEmpty() {
        return this.stored.equals(Occupant.EMPTY);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("occupant")) {
            Occupant.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("occupant")).resultOrPartial(string -> BiomesWeveGone.LOGGER.error("Failed to parse occupants: '{}'", string)).ifPresent(occupant -> {
                this.stored = occupant;
            });
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("occupant", (Tag)Occupant.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.stored).getOrThrow());
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.stored = (Occupant)componentInput.getOrDefault(BWGDataComponents.PUMPKIN_WARDEN.get(), (Object)Occupant.EMPTY);
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(BWGDataComponents.PUMPKIN_WARDEN.get(), (Object)this.stored);
    }

    public void emptyOccupant(Level level) {
        Entity entity;
        if (!this.isEmpty() && (entity = this.stored.createEntity(level)) instanceof PumpkinWarden) {
            PumpkinWarden pumpkinWarden = (PumpkinWarden)entity;
            pumpkinWarden.setPos((double)this.getBlockPos().getX() + 0.5, this.getBlockPos().getY(), (double)this.getBlockPos().getZ() + 0.5);
            pumpkinWarden.stopSleeping();
            level.addFreshEntity((Entity)pumpkinWarden);
            this.stored = Occupant.EMPTY;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PumpkinBurrowBlockEntity blockEntity) {
        Entity entity;
        if (!blockEntity.isEmpty() && level.isDay() && level.getRandom().nextBoolean() && (entity = blockEntity.stored.createEntity(level)) instanceof PumpkinWarden) {
            PumpkinWarden pumpkinWarden = (PumpkinWarden)entity;
            Direction direction = (Direction)state.getValue((Property)PumpkinBurrowBlock.FACING);
            BlockPos blockPos = pos.relative(direction);
            if (level.getBlockState(blockPos).getCollisionShape((BlockGetter)level, blockPos).isEmpty()) {
                pumpkinWarden.setPos((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5);
                pumpkinWarden.stopSleeping();
                pumpkinWarden.getBrain().setMemory(MemoryModuleType.HOME, (Object)new GlobalPos(level.dimension(), pos));
                level.addFreshEntity((Entity)pumpkinWarden);
                blockEntity.stored = Occupant.EMPTY;
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PumpkinBurrowBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public record Occupant(CustomData entityData) {
        public static final Occupant EMPTY = new Occupant(CustomData.EMPTY);
        public static final Codec<Occupant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CustomData.CODEC.optionalFieldOf("entity_data", (Object)CustomData.EMPTY).forGetter(Occupant::entityData)).apply((Applicative)instance, Occupant::new));
        public static final StreamCodec<ByteBuf, Occupant> STREAM_CODEC = StreamCodec.composite((StreamCodec)CustomData.STREAM_CODEC, Occupant::entityData, Occupant::new);

        public static Occupant of(Entity entity) {
            CompoundTag compoundTag = new CompoundTag();
            entity.save(compoundTag);
            IGNORED_TAGS.forEach(arg_0 -> ((CompoundTag)compoundTag).remove(arg_0));
            return new Occupant(CustomData.of((CompoundTag)compoundTag));
        }

        @Nullable
        public Entity createEntity(Level level) {
            CompoundTag compoundTag = this.entityData.copyTag();
            return EntityType.loadEntityRecursive((CompoundTag)compoundTag, (Level)level, entityx -> entityx);
        }
    }
}

