/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;

public class SharpenedRockFeature
extends Feature<NoneFeatureConfiguration> {
    public static final ImprovedNoise NOISE = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(100L));

    public SharpenedRockFeature(Codec<NoneFeatureConfiguration> noneFeatureConfigurationCodec) {
        super(noneFeatureConfigurationCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        BlockPos origin = featurePlaceContext.origin();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        WorldGenLevel level = featurePlaceContext.level();
        int radius = UniformInt.of((int)5, (int)12).sample(featurePlaceContext.random());
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int minY;
                mutableBlockPos.setWithOffset((Vec3i)origin, x, 0, z);
                double noise = NOISE.noise((double)mutableBlockPos.getX() * 0.1, 0.0, (double)mutableBlockPos.getZ() * 0.1);
                double factor = origin.distSqr((Vec3i)mutableBlockPos) / (double)Mth.square((int)radius);
                double amplifier = BlendingFunction.EaseInCirc.INSTANCE.apply(1.0 - factor, 0.0, 75.0);
                BlockPos.MutableBlockPos mutable1 = new BlockPos.MutableBlockPos();
                int y = minY = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, mutableBlockPos.getX(), mutableBlockPos.getZ()) - 1;
                while ((double)y < (double)minY + amplifier + Math.max(0.0, noise * (amplifier * 2.0))) {
                    if (mutableBlockPos.closerThan((Vec3i)origin, (double)radius)) {
                        mutable1.set(origin.getX() + x, y, origin.getZ() + z);
                        BlockState state = BWGBlocks.PACKED_BOREALIS_ICE.get().defaultBlockState();
                        level.setBlock((BlockPos)mutable1, state, 2);
                    }
                    ++y;
                }
            }
        }
        return true;
    }
}

