/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.custom.PumpkinBurrowBlock;
import org.jetbrains.annotations.NotNull;

public class EnterPumpkinBurrow
extends Behavior<PumpkinWarden> {
    public EnterPumpkinBurrow() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.HOME, (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden) {
        if (pumpkinWarden.isPassenger()) {
            return false;
        }
        Brain<PumpkinWarden> brain = pumpkinWarden.getBrain();
        GlobalPos globalPos = (GlobalPos)brain.getMemory(MemoryModuleType.HOME).get();
        if (level.dimension() != globalPos.dimension()) {
            return false;
        }
        BlockState blockState = level.getBlockState(globalPos.pos());
        if (!blockState.is((Block)BWGBlocks.PUMPKIN_BURROW.get())) {
            return false;
        }
        BlockPos entrancePos = globalPos.pos().relative((Direction)blockState.getValue((Property)PumpkinBurrowBlock.FACING));
        return level.getBlockState(entrancePos).getCollisionShape((BlockGetter)level, entrancePos).isEmpty() && entrancePos.equals((Object)pumpkinWarden.blockPosition()) && blockState.getBlock() instanceof PumpkinBurrowBlock && (Boolean)blockState.getValue((Property)PumpkinBurrowBlock.OCCUPIED) == false;
    }

    protected void start(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        Brain<PumpkinWarden> brain = pumpkinWarden.getBrain();
        if (brain.hasMemoryValue(MemoryModuleType.DOORS_TO_CLOSE)) {
            Set set = (Set)brain.getMemory(MemoryModuleType.DOORS_TO_CLOSE).get();
            Optional optional = brain.hasMemoryValue(MemoryModuleType.NEAREST_LIVING_ENTITIES) ? brain.getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES) : Optional.empty();
            InteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough((ServerLevel)level, (LivingEntity)pumpkinWarden, null, null, (Set)set, (Optional)optional);
        }
        pumpkinWarden.startSleeping(((GlobalPos)pumpkinWarden.getBrain().getMemory(MemoryModuleType.HOME).get()).pos());
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }
}

