/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.util;

import it.hurts.octostudios.octolib.util.AnimationUtils;
import java.util.Objects;

public final class OctoColor {
    public static final OctoColor RED = new OctoColor(1.0f, 0.0f, 0.0f, 1.0f);
    public static final OctoColor GREEN = new OctoColor(0.0f, 1.0f, 0.0f, 1.0f);
    public static final OctoColor BLUE = new OctoColor(0.0f, 0.0f, 1.0f, 1.0f);
    public static final OctoColor WHITE = new OctoColor(1.0f, 1.0f, 1.0f, 1.0f);
    public static final OctoColor BLACK = new OctoColor(0.0f, 0.0f, 0.0f, 1.0f);
    public static final OctoColor ZERO = new OctoColor(0.0f, 0.0f, 0.0f, 0.0f);
    private final float r;
    private final float g;
    private final float b;
    private final float a;

    public OctoColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public OctoColor(int argb) {
        this.a = (float)(argb >> 24 & 0xFF) / 255.0f;
        this.r = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.g = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.b = (float)(argb & 0xFF) / 255.0f;
    }

    public int getARGB() {
        return ((int)(this.a * 255.0f) & 0xFF) << 24 | ((int)(this.r * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | (int)(this.b * 255.0f) & 0xFF;
    }

    public OctoColor lerp(OctoColor other, double t) {
        return new OctoColor(AnimationUtils.FLOAT.lerp(Float.valueOf(this.r), Float.valueOf(other.r), t).floatValue(), AnimationUtils.FLOAT.lerp(Float.valueOf(this.g), Float.valueOf(other.g), t).floatValue(), AnimationUtils.FLOAT.lerp(Float.valueOf(this.b), Float.valueOf(other.b), t).floatValue(), AnimationUtils.FLOAT.lerp(Float.valueOf(this.a), Float.valueOf(other.a), t).floatValue());
    }

    public static OctoColor lerp(double t, OctoColor ... colors) {
        if (colors == null || colors.length == 0) {
            throw new IllegalArgumentException("colors array can't be empty");
        }
        if (colors.length == 1) {
            return colors[0];
        }
        t = Math.min(Math.max(t, 0.0), 1.0);
        double scaledT = t * (double)(colors.length - 1);
        int index = (int)Math.floor(scaledT);
        int nextIndex = Math.min(index + 1, colors.length - 1);
        double localT = scaledT - (double)index;
        return colors[index].lerp(colors[nextIndex], localT);
    }

    public OctoColor add(OctoColor other) {
        return new OctoColor(this.r + other.r, this.g + other.g, this.b + other.b, this.a + other.a);
    }

    public OctoColor subtract(OctoColor other) {
        return new OctoColor(this.r - other.r, this.g - other.g, this.b - other.b, this.a - other.a);
    }

    public OctoColor multiply(float rFactor, float gFactor, float bFactor, float aFactor) {
        return new OctoColor(this.r * rFactor, this.g * gFactor, this.b * bFactor, this.a * aFactor);
    }

    public OctoColor multiply(float factor) {
        return this.multiply(factor, factor, factor, factor);
    }

    public float r() {
        return this.r;
    }

    public float g() {
        return this.g;
    }

    public float b() {
        return this.b;
    }

    public float a() {
        return this.a;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OctoColor that = (OctoColor)obj;
        return Float.floatToIntBits(this.r) == Float.floatToIntBits(that.r) && Float.floatToIntBits(this.g) == Float.floatToIntBits(that.g) && Float.floatToIntBits(this.b) == Float.floatToIntBits(that.b) && Float.floatToIntBits(this.a) == Float.floatToIntBits(that.a);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    public String toString() {
        return "OctoColor[r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "]";
    }
}

