/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.client.screen.widget;

import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.screen.widget.Child;
import it.hurts.octostudios.octolib.client.screen.widget.HasRenderMatrix;
import it.hurts.octostudios.octolib.client.screen.widget.TestGear;
import it.hurts.octostudios.octolib.util.OctoColor;
import it.hurts.octostudios.octolib.util.RenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class TestPin
extends AbstractWidget
implements Child<TestGear> {
    OctoColor color = OctoColor.GREEN;
    TestGear parent;

    public TestPin(int x, int y, TestGear parent) {
        super(x, y, 24, 24, (Component)Component.empty());
        this.setParent(parent);
        this.setPosition(x, y);
    }

    @Override
    @Nullable
    public TestGear getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable TestGear parent) {
        this.parent = parent;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHovered() && this.color == OctoColor.GREEN) {
            this.color = OctoColor.BLUE;
        } else if (!this.isHovered() && this.color == OctoColor.BLUE) {
            this.color = OctoColor.GREEN;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        guiGraphics.renderOutline(0, 0, this.width, this.height, this.color.getARGB());
        guiGraphics.pose().popPose();
        TestGear testGear = this.getParent();
        if (testGear instanceof HasRenderMatrix) {
            TestGear has = testGear;
            guiGraphics.pose().pushPose();
            Vec2 bleh = RenderUtils.toScreenCoords(has.getMatrix(), mouseX, mouseY);
            guiGraphics.pose().translate((double)bleh.x - 0.5, (double)bleh.y - 0.5, 0.0);
            guiGraphics.renderOutline(0, 0, 2, 2, -65536);
            guiGraphics.pose().popPose();
        }
    }

    public void onClick(double mouseX, double mouseY) {
        super.onClick(mouseX, mouseY);
        Tween tween = Tween.create();
        tween.tweenMethod(this::setColor, OctoColor.RED, OctoColor.GREEN, 0.5);
        tween.start();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void setColor(OctoColor color) {
        this.color = color;
    }
}

