/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.relocated.net.neoforged.bus;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LockHelper<K, V> {
    private final IntFunction<Map<K, V>> mapConstructor;
    private final Map<K, V> backingMap;
    @Nullable
    private volatile Map<K, V> readOnlyView = null;
    private Object lock = new Object();

    public static <K, V> LockHelper<K, V> withHashMap() {
        return new LockHelper<K, V>(size -> new HashMap((size + 2) * 4 / 3));
    }

    public static <K, V> LockHelper<K, V> withIdentityHashMap() {
        return new LockHelper<K, V>(IdentityHashMap::new);
    }

    private LockHelper(IntFunction<Map<K, V>> mapConstructor) {
        this.mapConstructor = mapConstructor;
        this.backingMap = mapConstructor.apply(32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> getReadMap() {
        Map<K, V> map = this.readOnlyView;
        if (map == null) {
            Object object = this.lock;
            synchronized (object) {
                Map<K, V> updatedMap = this.mapConstructor.apply(this.backingMap.size());
                updatedMap.putAll(this.backingMap);
                this.readOnlyView = map = updatedMap;
            }
        }
        return map;
    }

    public V get(K key) {
        return this.getReadMap().get(key);
    }

    public boolean containsKey(K key) {
        return this.getReadMap().containsKey(key);
    }

    public V computeIfAbsent(K key, Function<K, V> factory) {
        return (V)this.computeIfAbsent(key, factory, Function.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <I> V computeIfAbsent(K key, Function<K, I> factory, Function<I, V> finalizer) {
        V ret = this.get(key);
        if (ret != null) {
            return ret;
        }
        I intermediate = factory.apply(key);
        Object object = this.lock;
        synchronized (object) {
            ret = this.backingMap.get(key);
            if (ret == null) {
                ret = finalizer.apply(intermediate);
                this.backingMap.put(key, ret);
                this.readOnlyView = null;
            }
        }
        return ret;
    }

    public void clearAll() {
        this.backingMap.clear();
        this.readOnlyView = null;
        this.lock = new Object();
    }
}

