/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.relocated.net.neoforged.bus;

import com.clefal.nirvana_lib.relocated.net.neoforged.bus.IWrapperListener;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.EventListener;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.EventPriority;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.ICancellableEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ListenerList {
    private static final EventPriority[] PRIORITIES = EventPriority.values();
    private boolean rebuild = true;
    private final AtomicReference<EventListener[]> listeners = new AtomicReference();
    private final AtomicReference<EventListener[][]> perPhaseListeners = new AtomicReference();
    private final ArrayList<ArrayList<EventListener>> priorities;
    @Nullable
    private final ListenerList parent;
    private List<ListenerList> children;
    private final Semaphore writeLock = new Semaphore(1, true);
    private final boolean canUnwrapListeners;
    private final boolean buildPerPhaseList;

    ListenerList(Class<?> eventClass, boolean buildPerPhaseList) {
        this(eventClass, null, buildPerPhaseList);
    }

    ListenerList(Class<?> eventClass, @Nullable ListenerList parent, boolean buildPerPhaseList) {
        int count = PRIORITIES.length;
        this.priorities = new ArrayList(count);
        for (int x = 0; x < count; ++x) {
            this.priorities.add(new ArrayList());
        }
        this.canUnwrapListeners = !ICancellableEvent.class.isAssignableFrom(eventClass);
        this.buildPerPhaseList = buildPerPhaseList;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    private ArrayList<EventListener> getListeners(EventPriority priority) {
        this.writeLock.acquireUninterruptibly();
        ArrayList<EventListener> ret = new ArrayList<EventListener>((Collection)this.priorities.get(priority.ordinal()));
        this.writeLock.release();
        if (this.parent != null) {
            ret.addAll(this.parent.getListeners(priority));
        }
        return ret;
    }

    public EventListener[] getListeners() {
        if (this.shouldRebuild()) {
            this.buildCache();
        }
        return this.listeners.get();
    }

    public EventListener[] getPhaseListeners(EventPriority phase) {
        if (!this.buildPerPhaseList) {
            throw new IllegalStateException("buildPerPhaseList is false!");
        }
        if (this.shouldRebuild()) {
            this.buildCache();
        }
        return this.perPhaseListeners.get()[phase.ordinal()];
    }

    protected boolean shouldRebuild() {
        return this.rebuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceRebuild() {
        this.rebuild = true;
        if (this.children != null) {
            List<ListenerList> list = this.children;
            synchronized (list) {
                for (ListenerList child : this.children) {
                    child.forceRebuild();
                }
            }
        }
    }

    private void addChild(ListenerList child) {
        if (this.children == null) {
            this.children = Collections.synchronizedList(new ArrayList(2));
        }
        this.children.add(child);
    }

    private void buildCache() {
        if (this.parent != null && this.parent.shouldRebuild()) {
            this.parent.buildCache();
        }
        ArrayList<EventListener> ret = new ArrayList<EventListener>();
        EventListener[][] perPhaseListeners = this.buildPerPhaseList ? new EventListener[PRIORITIES.length][] : null;
        for (EventPriority phase : PRIORITIES) {
            ArrayList<EventListener> phaseListeners = this.getListeners(phase);
            this.unwrapListeners(phaseListeners);
            ret.addAll(phaseListeners);
            if (perPhaseListeners == null) continue;
            perPhaseListeners[phase.ordinal()] = (EventListener[])phaseListeners.toArray(EventListener[]::new);
        }
        this.listeners.set(ret.toArray(new EventListener[0]));
        this.perPhaseListeners.set(perPhaseListeners);
        this.rebuild = false;
    }

    private void unwrapListeners(List<EventListener> ret) {
        if (this.canUnwrapListeners) {
            for (int i = 0; i < ret.size(); ++i) {
                EventListener eventListener = ret.get(i);
                if (!(eventListener instanceof IWrapperListener)) continue;
                IWrapperListener wrapper = (IWrapperListener)((Object)eventListener);
                ret.set(i, wrapper.getWithoutCheck());
            }
        }
    }

    public void register(EventPriority priority, EventListener listener) {
        this.writeLock.acquireUninterruptibly();
        this.priorities.get(priority.ordinal()).add(listener);
        this.writeLock.release();
        this.forceRebuild();
    }

    public void unregister(EventListener listener) {
        this.writeLock.acquireUninterruptibly();
        this.priorities.stream().filter(list -> list.remove(listener)).forEach(list -> this.forceRebuild());
        this.writeLock.release();
    }
}

