/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.relocated.io.vavr;

import com.clefal.nirvana_lib.relocated.io.vavr.GwtIncompatible;
import com.clefal.nirvana_lib.relocated.io.vavr.Value;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.Iterator;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.Seq;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.Vector;
import com.clefal.nirvana_lib.relocated.io.vavr.control.Option;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;

public final class Lazy<T>
implements Value<T>,
Supplier<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile transient Supplier<? extends T> supplier;
    private T value;

    private Lazy(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    public static <T> Lazy<T> narrow(Lazy<? extends T> lazy) {
        return lazy;
    }

    public static <T> Lazy<T> of(@NonNull Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        if (supplier instanceof Lazy) {
            return (Lazy)supplier;
        }
        return new Lazy<T>(supplier);
    }

    public static <T> Lazy<Seq<T>> sequence(@NonNull Iterable<? extends Lazy<? extends T>> values) {
        Objects.requireNonNull(values, "values is null");
        return Lazy.of(() -> Vector.ofAll(values).map((T lazy) -> lazy.get()));
    }

    @GwtIncompatible(value="reflection is not supported")
    public static <T> T val(@NonNull Supplier<? extends T> supplier, @NonNull Class<T> type) {
        Objects.requireNonNull(supplier, "supplier is null");
        Objects.requireNonNull(type, "type is null");
        if (!type.isInterface()) {
            throw new IllegalArgumentException("type has to be an interface");
        }
        Lazy lazy = Lazy.of(supplier);
        InvocationHandler handler = (proxy, method, args) -> method.invoke(lazy.get(), args);
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler);
    }

    public Option<T> filter(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        T v = this.get();
        return predicate.test(v) ? Option.some(v) : Option.none();
    }

    @Override
    public T get() {
        return this.supplier == null ? this.value : this.computeValue();
    }

    private T computeValue() {
        this.lock.lock();
        try {
            Supplier<T> s = this.supplier;
            if (s != null) {
                this.value = s.get();
                this.supplier = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.value;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public boolean isEvaluated() {
        return this.supplier == null;
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    @Override
    public boolean isSingleValued() {
        return true;
    }

    @Override
    public @NonNull Iterator<T> iterator() {
        return Iterator.of(this.get());
    }

    @Override
    public <U> Lazy<U> map(@NonNull Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return Lazy.of(() -> mapper.apply((T)this.get()));
    }

    @Override
    public <U> Lazy<U> mapTo(U value) {
        return this.map((T ignored) -> value);
    }

    public Lazy<Void> mapToVoid() {
        return this.map((T ignored) -> null);
    }

    @Override
    public Lazy<T> peek(@NonNull Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        action.accept(this.get());
        return this;
    }

    public <U> U transform(@NonNull Function<? super Lazy<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    public String stringPrefix() {
        return "Lazy";
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Lazy && Objects.equals(((Lazy)o).get(), this.get());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.get());
    }

    @Override
    public String toString() {
        return this.stringPrefix() + "(" + (!this.isEvaluated() ? "?" : this.value) + ")";
    }

    @GwtIncompatible(value="The Java serialization protocol is explicitly not supported")
    private void writeObject(ObjectOutputStream s) throws IOException {
        this.get();
        s.defaultWriteObject();
    }
}

