/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.moretotems.mixin;

import java.util.Objects;
import net.hyper_pigeon.moretotems.entity.SummonedBeeEntity;
import net.hyper_pigeon.moretotems.entity.SummonedZombieEntity;
import net.hyper_pigeon.moretotems.register.EntityRegistry;
import net.hyper_pigeon.moretotems.register.ItemRegistry;
import net.hyper_pigeon.moretotems.register.StatusEffectRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public EntityType<SummonedBeeEntity> s_bee = EntityRegistry.SUMMONED_BEE.get();
    public MinecraftServer the_server = this.getServer();

    @Shadow
    public native ItemStack getItemInHand(InteractionHand var1);

    @Shadow
    public native boolean hasEffect(Holder<MobEffect> var1);

    @Shadow
    public native void setHealth(float var1);

    @Shadow
    public native boolean removeAllEffects();

    @Shadow
    public native boolean addEffect(MobEffectInstance var1);

    @Shadow
    public abstract boolean addEffect(MobEffectInstance var1, @Nullable Entity var2);

    @Shadow
    public abstract Brain<?> getBrain();

    protected LivingEntityMixin(EntityType<?> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    @Inject(at={@At(value="HEAD")}, method={"checkTotemDeathProtection"}, cancellable=true)
    public void useExplosiveTotem(DamageSource damageSource_1, CallbackInfoReturnable<Boolean> callback) {
        LivingEntityMixin entity = this;
        ItemStack offhand_stack = entity.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack mainhand_stack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (offhand_stack.getItem() == ItemRegistry.EXPLOSIVE_TOTEM_OF_UNDYING.get() || mainhand_stack.getItem() == ItemRegistry.EXPLOSIVE_TOTEM_OF_UNDYING.get()) {
            if (damageSource_1.type().equals((Object)DamageTypes.FELL_OUT_OF_WORLD)) {
                callback.setReturnValue((Object)false);
            } else {
                if (offhand_stack.getItem() == ItemRegistry.EXPLOSIVE_TOTEM_OF_UNDYING.get()) {
                    offhand_stack.shrink(1);
                } else if (mainhand_stack.getItem() == ItemRegistry.EXPLOSIVE_TOTEM_OF_UNDYING.get()) {
                    mainhand_stack.shrink(1);
                }
                this.setHealth(1.0f);
                this.removeAllEffects();
                this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 125, 2));
                this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 350, 4));
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 2));
                this.level().broadcastEntityEvent((Entity)this, (byte)35);
                PrimedTnt tntEntity = (PrimedTnt)EntityType.TNT.create(this.level());
                tntEntity.setFuse(10);
                tntEntity.moveTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
                this.level().addFreshEntity((Entity)tntEntity);
                callback.setReturnValue((Object)true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"checkTotemDeathProtection"}, cancellable=true)
    public void useStingingTotem(DamageSource damageSource_1, CallbackInfoReturnable<Boolean> callback) {
        LivingEntityMixin entity = this;
        ItemStack offhand_stack = entity.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack mainhand_stack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (offhand_stack.getItem() == ItemRegistry.STINGING_TOTEM_OF_UNDYING.get() || mainhand_stack.getItem() == ItemRegistry.STINGING_TOTEM_OF_UNDYING.get()) {
            if (damageSource_1.type().equals((Object)DamageTypes.FELL_OUT_OF_WORLD)) {
                callback.setReturnValue((Object)false);
            } else {
                if (offhand_stack.getItem() == ItemRegistry.STINGING_TOTEM_OF_UNDYING.get()) {
                    offhand_stack.shrink(1);
                } else if (mainhand_stack.getItem() == ItemRegistry.STINGING_TOTEM_OF_UNDYING.get()) {
                    mainhand_stack.shrink(1);
                }
                this.setHealth(1.0f);
                this.removeAllEffects();
                this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 650, 1));
                this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 1500, 1));
                this.level().broadcastEntityEvent((Entity)this, (byte)35);
                SummonedBeeEntity summonedBeeEntity_1 = (SummonedBeeEntity)this.s_bee.create(this.level());
                summonedBeeEntity_1.setSummoner(this);
                summonedBeeEntity_1.moveTo(this.getX(), this.getY() + 1.0, this.getZ(), 0.0f, 0.0f);
                this.level().addFreshEntity((Entity)summonedBeeEntity_1);
                SummonedBeeEntity summonedBeeEntity_2 = (SummonedBeeEntity)this.s_bee.create(this.level());
                summonedBeeEntity_2.setSummoner(this);
                summonedBeeEntity_2.moveTo(this.getX(), this.getY() + 1.0, this.getZ(), 0.0f, 0.0f);
                this.level().addFreshEntity((Entity)summonedBeeEntity_2);
                SummonedBeeEntity summonedBeeEntity_3 = (SummonedBeeEntity)this.s_bee.create(this.level());
                summonedBeeEntity_3.setSummoner(this);
                summonedBeeEntity_3.moveTo(this.getX() + 1.0, this.getY() + 1.0, this.getZ(), 0.0f, 0.0f);
                this.level().addFreshEntity((Entity)summonedBeeEntity_3);
                SummonedBeeEntity summonedBeeEntity_4 = (SummonedBeeEntity)this.s_bee.create(this.level());
                summonedBeeEntity_4.setSummoner(this);
                summonedBeeEntity_4.moveTo(this.getX(), this.getY() + 1.0, this.getZ() + 1.0, 0.0f, 0.0f);
                this.level().addFreshEntity((Entity)summonedBeeEntity_4);
                SummonedBeeEntity summonedBeeEntity_5 = (SummonedBeeEntity)this.s_bee.create(this.level());
                summonedBeeEntity_5.setSummoner(this);
                summonedBeeEntity_5.moveTo(this.getX() - 1.0, this.getY() + 1.0, this.getZ(), 0.0f, 0.0f);
                this.level().addFreshEntity((Entity)summonedBeeEntity_5);
                SummonedBeeEntity summonedBeeEntity_6 = (SummonedBeeEntity)this.s_bee.create(this.level());
                summonedBeeEntity_5.setSummoner(this);
                summonedBeeEntity_5.moveTo(this.getX(), this.getY() + 1.0, this.getZ() - 1.0, 0.0f, 0.0f);
                this.level().addFreshEntity((Entity)summonedBeeEntity_6);
                callback.setReturnValue((Object)true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"checkTotemDeathProtection"}, cancellable=true)
    public void useTeleportingTotem(DamageSource damageSource_1, CallbackInfoReturnable<Boolean> callback) {
        LivingEntity entity = (LivingEntity)this;
        ItemStack offhand_stack = entity.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack mainhand_stack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (offhand_stack.getItem() == ItemRegistry.TELEPORTING_TOTEM_OF_UNDYING.get() || mainhand_stack.getItem() == ItemRegistry.TELEPORTING_TOTEM_OF_UNDYING.get()) {
            if (offhand_stack.getItem() == ItemRegistry.TELEPORTING_TOTEM_OF_UNDYING.get()) {
                offhand_stack.shrink(1);
            } else {
                mainhand_stack.shrink(1);
            }
            this.setHealth(1.0f);
            this.clearFire();
            this.fallDistance = 0.0f;
            this.removeAllEffects();
            this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 17500, 5));
            if (entity instanceof ServerPlayer && !this.level().isClientSide()) {
                ServerPlayer player = (ServerPlayer)entity;
                ServerLevel dest = Objects.requireNonNullElse(player.getServer().getLevel(player.getRespawnDimension()), player.getServer().overworld());
                dest.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, new ChunkPos(SectionPos.posToSectionCoord((double)player.getRespawnPosition().getX()), SectionPos.posToSectionCoord((double)player.getRespawnPosition().getZ())), 1, (Object)player.getId());
                player.changeDimension(new DimensionTransition(dest, this.position(), player.getDeltaMovement(), player.getYRot(), player.getXRot(), DimensionTransition.DO_NOTHING));
                player.teleportTo(dest, (double)player.getRespawnPosition().getX(), (double)player.getRespawnPosition().getY(), (double)player.getRespawnPosition().getZ(), 5.0f, 5.0f);
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
                this.level().broadcastEntityEvent((Entity)this, (byte)35);
                callback.setReturnValue((Object)true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"checkTotemDeathProtection"}, cancellable=true)
    public void useGhastlyTotem(DamageSource damageSource_1, CallbackInfoReturnable<Boolean> callback) {
        LivingEntityMixin entity = this;
        ItemStack offhand_stack = entity.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack mainhand_stack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (offhand_stack.getItem() == ItemRegistry.GHASTLY_TOTEM_OF_UNDYING.get() || mainhand_stack.getItem() == ItemRegistry.GHASTLY_TOTEM_OF_UNDYING.get()) {
            if (damageSource_1.type().equals((Object)DamageTypes.FELL_OUT_OF_WORLD)) {
                callback.setReturnValue((Object)false);
            } else {
                if (offhand_stack.getItem() == ItemRegistry.GHASTLY_TOTEM_OF_UNDYING.get()) {
                    offhand_stack.shrink(1);
                } else if (mainhand_stack.getItem() == ItemRegistry.GHASTLY_TOTEM_OF_UNDYING.get()) {
                    mainhand_stack.shrink(1);
                }
                this.setHealth(1.0f);
                this.removeAllEffects();
                this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 1325, 1));
                this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 1525, 2));
                this.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 1000, 1));
                this.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 1750, 1));
                this.level().broadcastEntityEvent((Entity)this, (byte)35);
                callback.setReturnValue((Object)true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"checkTotemDeathProtection"}, cancellable=true)
    public void useSkeletalTotem(DamageSource damageSource_1, CallbackInfoReturnable<Boolean> callback) {
        LivingEntityMixin entity = this;
        ItemStack offhand_stack = entity.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack mainhand_stack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (offhand_stack.getItem() == ItemRegistry.SKELETAL_TOTEM_OF_UNDYING.get() || mainhand_stack.getItem() == ItemRegistry.SKELETAL_TOTEM_OF_UNDYING.get()) {
            if (damageSource_1.type().equals((Object)DamageTypes.FELL_OUT_OF_WORLD)) {
                callback.setReturnValue((Object)false);
            } else {
                if (offhand_stack.getItem() == ItemRegistry.SKELETAL_TOTEM_OF_UNDYING.get()) {
                    offhand_stack.shrink(1);
                } else if (mainhand_stack.getItem() == ItemRegistry.SKELETAL_TOTEM_OF_UNDYING.get()) {
                    mainhand_stack.shrink(1);
                }
                this.setHealth(1.0f);
                this.removeAllEffects();
                this.addEffect(new MobEffectInstance(StatusEffectRegistry.SNIPER, 2000, 0));
                this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 600, 0));
                this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 350, 1));
                this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 250, 0));
                this.level().broadcastEntityEvent((Entity)this, (byte)35);
                callback.setReturnValue((Object)true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"checkTotemDeathProtection"}, cancellable=true)
    public void useTentacledTotem(DamageSource damageSource_1, CallbackInfoReturnable<Boolean> callback) {
        LivingEntityMixin entity = this;
        ItemStack offhand_stack = entity.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack mainhand_stack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (offhand_stack.getItem() == ItemRegistry.TENTACLED_TOTEM_OF_UNDYING.get() || mainhand_stack.getItem() == ItemRegistry.TENTACLED_TOTEM_OF_UNDYING.get()) {
            if (damageSource_1.type().equals((Object)DamageTypes.FELL_OUT_OF_WORLD)) {
                callback.setReturnValue((Object)false);
            } else {
                if (offhand_stack.getItem() == ItemRegistry.TENTACLED_TOTEM_OF_UNDYING.get()) {
                    offhand_stack.shrink(1);
                } else if (mainhand_stack.getItem() == ItemRegistry.TENTACLED_TOTEM_OF_UNDYING.get()) {
                    mainhand_stack.shrink(1);
                }
                this.setHealth(1.0f);
                this.removeAllEffects();
                this.addEffect(new MobEffectInstance(StatusEffectRegistry.CEPHALOPOD, 2000, 0));
                this.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 2000, 0));
                this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 950, 1));
                this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 200, 2));
                this.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 950, 0));
                this.level().broadcastEntityEvent((Entity)this, (byte)35);
                callback.setReturnValue((Object)true);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"hurt"}, cancellable=true)
    public void applyCephalopodEffect(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callback) {
        Entity entity3 = source.getEntity();
        LivingEntityMixin entity = this;
        if (entity3 instanceof LivingEntity) {
            if (entity3 != null) {
                if (((LivingEntity)entity3).hasEffect(StatusEffectRegistry.CEPHALOPOD)) {
                    this.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 450, 1));
                    callback.setReturnValue((Object)true);
                } else if (entity.hasEffect(StatusEffectRegistry.CEPHALOPOD)) {
                    ((LivingEntity)entity3).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 450, 1));
                    ((LivingEntity)entity3).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 150, 0));
                }
            } else {
                callback.setReturnValue((Object)false);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"checkTotemDeathProtection"}, cancellable=true)
    public void useRottingTotem(DamageSource damageSource_1, CallbackInfoReturnable<Boolean> callback) {
        LivingEntityMixin entity = this;
        ItemStack offhand_stack = entity.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack mainhand_stack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (offhand_stack.getItem() == ItemRegistry.ROTTING_TOTEM_OF_UNDYING.get() || mainhand_stack.getItem() == ItemRegistry.ROTTING_TOTEM_OF_UNDYING.get()) {
            if (damageSource_1.type().equals((Object)DamageTypes.FELL_OUT_OF_WORLD)) {
                callback.setReturnValue((Object)false);
            } else {
                if (offhand_stack.getItem() == ItemRegistry.ROTTING_TOTEM_OF_UNDYING.get()) {
                    offhand_stack.shrink(1);
                } else if (mainhand_stack.getItem() == ItemRegistry.ROTTING_TOTEM_OF_UNDYING.get()) {
                    mainhand_stack.shrink(1);
                }
                this.setHealth(1.0f);
                this.removeAllEffects();
                this.addEffect(new MobEffectInstance(StatusEffectRegistry.NECROSIS, 2000, 0));
                this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 300, 2));
                this.addEffect(new MobEffectInstance(MobEffects.POISON, 400, 0));
                SummonedZombieEntity zombie_spawn = (SummonedZombieEntity)EntityRegistry.SUMMONED_ZOMBIE.get().create(this.level());
                SummonedZombieEntity zombie_spawn_two = (SummonedZombieEntity)EntityRegistry.SUMMONED_ZOMBIE.get().create(this.level());
                SummonedZombieEntity zombie_spawn_three = (SummonedZombieEntity)EntityRegistry.SUMMONED_ZOMBIE.get().create(this.level());
                SummonedZombieEntity zombie_spawn_four = (SummonedZombieEntity)EntityRegistry.SUMMONED_ZOMBIE.get().create(this.level());
                assert (zombie_spawn != null);
                zombie_spawn.setSummoner(this);
                assert (zombie_spawn_two != null);
                zombie_spawn_two.setSummoner(this);
                assert (zombie_spawn_three != null);
                zombie_spawn_three.setSummoner(this);
                assert (zombie_spawn_four != null);
                zombie_spawn_four.setSummoner(this);
                zombie_spawn.moveTo(this.getX(), this.getY(), this.getZ() + 3.0, 0.0f, 0.0f);
                zombie_spawn_two.moveTo(this.getX(), this.getY(), this.getZ() - 3.0, 0.0f, 0.0f);
                zombie_spawn_three.moveTo(this.getX() - 3.0, this.getY(), this.getZ(), 0.0f, 0.0f);
                zombie_spawn_four.moveTo(this.getX() + 2.0, this.getY(), this.getZ() + 2.0, 0.0f, 0.0f);
                this.level().addFreshEntity((Entity)zombie_spawn);
                this.level().addFreshEntity((Entity)zombie_spawn_two);
                this.level().addFreshEntity((Entity)zombie_spawn_three);
                this.level().addFreshEntity((Entity)zombie_spawn_four);
                this.level().broadcastEntityEvent((Entity)this, (byte)35);
                callback.setReturnValue((Object)true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvertedHealAndHarm"}, cancellable=true)
    public void NecroCheck(CallbackInfoReturnable<Boolean> callback) {
        if (this.hasEffect(StatusEffectRegistry.NECROSIS)) {
            callback.setReturnValue((Object)true);
        } else if (this.getType().is(EntityTypeTags.UNDEAD)) {
            callback.setReturnValue((Object)true);
        }
    }
}

