/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.moretotems.goals;

import net.hyper_pigeon.moretotems.entity.SummonedZombieEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FollowZombieSummonerGoal
extends Goal {
    private final SummonedZombieEntity minion;
    private LivingEntity summoner;
    private final LevelReader world;
    private final double field_6442;
    private final PathNavigation navigation;
    private int field_6443;
    private final float maxDistance;
    private final float minDistance;
    private final boolean field_21078;

    public FollowZombieSummonerGoal(SummonedZombieEntity minion, LivingEntity summoner, LevelReader world, double speed, PathNavigation navigation, float maxDistance, float minDistance, boolean field_21078) {
        this.minion = minion;
        this.summoner = summoner;
        this.world = world;
        this.field_6442 = speed;
        this.navigation = navigation;
        this.maxDistance = maxDistance;
        this.minDistance = minDistance;
        this.field_21078 = field_21078;
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.minion.getSummoner();
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity.isSpectator()) {
            return false;
        }
        if (this.minion.distanceToSqr((Entity)livingEntity) < (double)(this.minDistance * this.minDistance)) {
            return false;
        }
        this.summoner = livingEntity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        return this.minion.distanceToSqr((Entity)this.summoner) > (double)(this.maxDistance * this.maxDistance);
    }

    public void tick() {
        this.minion.getLookControl().setLookAt((Entity)this.summoner, 10.0f, this.minion.getXRot());
        if (--this.field_6443 <= 0) {
            this.field_6443 = 10;
            if (!this.minion.isPassenger()) {
                if (this.minion.distanceToSqr((Entity)this.summoner) >= 144.0) {
                    this.method_23345();
                } else {
                    this.navigation.moveTo((Entity)this.summoner, this.field_6442);
                }
            }
        }
    }

    private void method_23345() {
        BlockPos blockPos = new BlockPos((Vec3i)this.summoner.blockPosition());
        for (int i = 0; i < 10; ++i) {
            int j = this.method_23342(-3, 3);
            int k = this.method_23342(-1, 1);
            int l = this.method_23342(-3, 3);
            boolean bl = this.method_23343(blockPos.getX() + j, blockPos.getY() + k, blockPos.getZ() + l);
            if (!bl) continue;
            return;
        }
    }

    private boolean method_23343(int i, int j, int k) {
        if (Math.abs((double)i - this.summoner.getX()) < 2.0 && Math.abs((double)k - this.summoner.getZ()) < 2.0) {
            return false;
        }
        if (!this.method_23344(new BlockPos(i, j, k))) {
            return false;
        }
        this.navigation.stop();
        return true;
    }

    private boolean method_23344(BlockPos blockPos) {
        PathType pathNodeType = WalkNodeEvaluator.getPathTypeStatic((Mob)this.minion, (BlockPos)new BlockPos.MutableBlockPos());
        if (pathNodeType != PathType.WALKABLE) {
            return false;
        }
        BlockState blockState = this.world.getBlockState(blockPos.below());
        if (!this.field_21078 && blockState.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockPos2 = blockPos.subtract((Vec3i)new BlockPos((Vec3i)this.minion.blockPosition()));
        return this.world.noCollision((Entity)this.minion, this.minion.getBoundingBox().move(blockPos2));
    }

    private int method_23342(int i, int j) {
        return this.minion.getRandom().nextInt(j - i + 1) + i;
    }
}

