/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.moretotems.entity;

import java.util.Optional;
import java.util.UUID;
import net.hyper_pigeon.moretotems.goals.FollowZombieSummonerGoal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class SummonedZombieEntity
extends Zombie {
    protected static final EntityDataAccessor<Optional<UUID>> SUMMONER_UUID = SynchedEntityData.defineId(SummonedZombieEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public SummonedZombieEntity(EntityType<? extends Zombie> type, Level world) {
        super(type, world);
    }

    protected void randomizeReinforcementsChance() {
        super.randomizeReinforcementsChance();
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.35);
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(3.5);
        this.getAttribute(Attributes.ARMOR).setBaseValue(2.8);
    }

    protected void defineSynchedData(SynchedEntityData.Builder syncedDataBuilder) {
        super.defineSynchedData(syncedDataBuilder);
        syncedDataBuilder.define(SUMMONER_UUID, Optional.empty());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(6, (Goal)new FollowZombieSummonerGoal(this, this.getSummoner(), (LevelReader)this.level(), 1.0, this.getNavigation(), 90.0f, 3.0f, true));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(1, (Goal)new ZombieAttackGoal((Zombie)this, 2.0, true));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    private void setSummonerUuid(UUID uuid) {
        this.entityData.set(SUMMONER_UUID, Optional.ofNullable(uuid));
    }

    public Optional<UUID> getSummonerUuid() {
        return (Optional)this.entityData.get(SUMMONER_UUID);
    }

    public void setSummoner(Entity player) {
        this.setSummonerUuid(player.getUUID());
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.getSummonerUuid().ifPresent(uuid -> tag.putString("SummonerUUID", uuid.toString()));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        UUID id = tag.contains("SummonerUUID") ? tag.getUUID("SummonerUUID") : tag.getUUID("SummonerUUID");
        if (id != null) {
            this.setSummonerUuid(tag.getUUID("SummonerUUID"));
        }
    }

    public void setLastHurtByMob(LivingEntity attacker) {
        if (attacker != this.getSummoner()) {
            super.setLastHurtByMob(attacker);
        }
    }

    public void aiStep() {
        if (this.isAlive() && this.getSummoner() != null) {
            if (this.getSummoner().getLastHurtByMob() != null) {
                this.setTarget(this.getSummoner().getLastHurtByMob());
            } else if (this.getSummoner().getLastHurtMob() != null) {
                this.setTarget(this.getSummoner().getLastHurtMob());
            }
        }
        super.aiStep();
    }

    public LivingEntity getSummoner() {
        try {
            Optional<UUID> uUID = this.getSummonerUuid();
            return uUID.map(value -> this.level().getPlayerByUUID(value)).orElse(null);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }
}

