/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.moretotems.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SummonedBeeEntity
extends Bee {
    private Entity summoner;

    public SummonedBeeEntity(EntityType<? extends Bee> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder createTotemBeeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.FLYING_SPEED, 2.5).add(Attributes.MOVEMENT_SPEED, 2.5).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public void setSummoner(Entity player) {
        this.summoner = player;
    }

    protected void customServerAiStep() {
        if (this.summoner instanceof Player) {
            if (((Player)this.summoner).getLastHurtByMob() != null) {
                this.setBeeAttacker(((Player)this.summoner).getLastHurtByMob());
            }
            if (((Player)this.summoner).getLastHurtMob() != null) {
                this.setBeeAttacker(((Player)this.summoner).getLastHurtMob());
            }
        }
        super.customServerAiStep();
    }

    private boolean setBeeAttacker(LivingEntity attacker) {
        if (attacker.equals((Object)this.summoner)) {
            return false;
        }
        this.setLastHurtByMob(attacker);
        return true;
    }

    public boolean doHurtTarget(Entity target) {
        if (target.equals((Object)this.summoner)) {
            return false;
        }
        if (this.hasStung()) {
            return false;
        }
        return super.doHurtTarget(target);
    }
}

