/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.item;

import gisellevonbingen.mmp.common.item.MMPItems;
import java.util.List;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MMPCreativeModeTab
extends CreativeModeTab {
    private List<? extends Item> items;
    private int iconIndex = 0;
    private long lastMillis = 0L;
    private ItemStack icon = null;
    private ItemStack fallbackIcon = null;

    public MMPCreativeModeTab(CreativeModeTab.Builder builder) {
        super(builder);
    }

    public ItemStack makeIcon() {
        int size;
        if (this.items == null) {
            this.items = MMPItems.ITEMS.getEntries().stream().map(i -> (Item)i.get()).toList();
        }
        if ((size = this.items.size()) > 0) {
            this.iconIndex %= size;
            return this.items.get(this.iconIndex).getDefaultInstance();
        }
        if (this.fallbackIcon == null) {
            this.fallbackIcon = new ItemStack((ItemLike)MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER);
        }
        return this.fallbackIcon;
    }

    public ItemStack getIconItem() {
        long millis = System.currentTimeMillis();
        if (this.icon == null || this.lastMillis == 0L || millis - this.lastMillis > 2000L) {
            this.icon = this.makeIcon();
            this.lastMillis = millis;
            ++this.iconIndex;
        }
        return this.icon;
    }
}

