/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.crafting;

import gisellevonbingen.mmp.common.MoreMekanismProcessing;
import gisellevonbingen.mmp.common.RepresentationUtils;
import gisellevonbingen.mmp.common.crafting.ITaggedOutputRecipe;
import gisellevonbingen.mmp.common.crafting.MMPRecipeSerializers;
import java.util.Collections;
import java.util.List;
import mekanism.api.recipes.basic.BasicEnrichingRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.registries.MekanismItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class EnrichingTaggedOutputRecipe
extends BasicEnrichingRecipe
implements ITaggedOutputRecipe {
    protected final ItemStackIngredient output;
    private int revision;
    private ItemStack cachedResult;

    public EnrichingTaggedOutputRecipe(ItemStackIngredient input, ItemStackIngredient output) {
        super(input, MekanismItems.ATOMIC_ALLOY.asStack());
        this.output = output;
    }

    public RecipeSerializer<BasicEnrichingRecipe> getSerializer() {
        return (RecipeSerializer)MMPRecipeSerializers.TAG_ENRICHING.get();
    }

    @Override
    public ItemStackIngredient getTaggedResult() {
        return this.output;
    }

    @Override
    public ItemStack getItemStackResult() {
        int revision = MoreMekanismProcessing.TAGS_UPDATED_REVISION;
        if (this.revision != revision || this.cachedResult == null) {
            this.revision = revision;
            this.cachedResult = RepresentationUtils.getRepresentation(this.output);
        }
        return this.cachedResult;
    }

    public ItemStack getOutput(ItemStack input) {
        return this.getItemStackResult().copy();
    }

    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.getItemStackResult().copy();
    }

    public List<ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.getItemStackResult());
    }

    public ItemStack getOutputRaw() {
        return this.getItemStackResult();
    }
}

