/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.init;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.datagen.model.MachineModelProperties;
import aztech.modern_industrialization.datagen.model.MachineModelsToGenerate;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.AbstractStorageMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.BoilerMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.ConfigurableChestMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.ConfigurableTankMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.ElectricWaterPumpBlockEntity;
import aztech.modern_industrialization.machines.blockentities.GeneratorMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.ReplicatorMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.SteamWaterPumpBlockEntity;
import aztech.modern_industrialization.machines.blockentities.StorageMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.TransformerMachineBlockEntity;
import aztech.modern_industrialization.machines.components.FluidItemConsumerComponent;
import aztech.modern_industrialization.machines.init.MachineRegistrationHelper;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import java.util.HashSet;
import java.util.List;

public class SingleBlockSpecialMachines {
    public static void init() {
        MachineRegistrationHelper.registerMachine("Bronze Boiler", "bronze_boiler", bet -> new BoilerMachineBlockEntity((BEP)bet, true), MachineBlockEntity::registerFluidApi, MachineBlockEntity::registerItemApi);
        MachineRegistrationHelper.registerMachine("Steel Boiler", "steel_boiler", bet -> new BoilerMachineBlockEntity((BEP)bet, false), MachineBlockEntity::registerFluidApi, MachineBlockEntity::registerItemApi);
        MachineRegistrationHelper.registerMachine("Bronze Water Pump", "bronze_water_pump", bet -> new SteamWaterPumpBlockEntity((BEP)bet, true), MachineBlockEntity::registerFluidApi);
        MachineRegistrationHelper.registerMachine("Steel Water Pump", "steel_water_pump", bet -> new SteamWaterPumpBlockEntity((BEP)bet, false), MachineBlockEntity::registerFluidApi);
        MachineRegistrationHelper.registerMachine("Electric Water Pump", "electric_water_pump", ElectricWaterPumpBlockEntity::new, MachineBlockEntity::registerFluidApi, ElectricWaterPumpBlockEntity::registerEnergyApi);
        SingleBlockSpecialMachines.registerTransformers();
        SingleBlockSpecialMachines.registerEUStorage();
        SingleBlockSpecialMachines.registerSteamTurbine(CableTier.LV, 32, 16000);
        SingleBlockSpecialMachines.registerSteamTurbine(CableTier.MV, 128, 32000);
        SingleBlockSpecialMachines.registerSteamTurbine(CableTier.HV, 512, 64000);
        MachineRegistrationHelper.registerMachine("LV Diesel Generator", "lv_diesel_generator", bet -> new GeneratorMachineBlockEntity((BEP)bet, "lv_diesel_generator", false, CableTier.LV, 4000L, 16000L, FluidItemConsumerComponent.ofFluidFuels(64L)), MachineBlockEntity::registerFluidApi, GeneratorMachineBlockEntity::registerEnergyApi);
        MachineRegistrationHelper.registerMachine("MV Diesel Generator", "mv_diesel_generator", bet -> new GeneratorMachineBlockEntity((BEP)bet, "mv_diesel_generator", false, CableTier.MV, 12000L, 32000L, FluidItemConsumerComponent.ofFluidFuels(256L)), MachineBlockEntity::registerFluidApi, GeneratorMachineBlockEntity::registerEnergyApi);
        MachineRegistrationHelper.registerMachine("HV Diesel Generator", "hv_diesel_generator", bet -> new GeneratorMachineBlockEntity((BEP)bet, "hv_diesel_generator", false, CableTier.HV, 60000L, 64000L, FluidItemConsumerComponent.ofFluidFuels(1024L)), MachineBlockEntity::registerFluidApi, GeneratorMachineBlockEntity::registerEnergyApi);
        MachineRegistrationHelper.registerMachine("Configurable Chest", "configurable_chest", ConfigurableChestMachineBlockEntity::new, MachineBlockEntity::registerItemApi);
        MachineRegistrationHelper.registerMachine("Configurable Tank", "configurable_tank", ConfigurableTankMachineBlockEntity::new, MachineBlockEntity::registerFluidApi);
        MachineRegistrationHelper.registerMachine("Replicator", "replicator", ReplicatorMachineBlockEntity::new, MachineBlockEntity::registerFluidApi, MachineBlockEntity::registerItemApi);
        MachineRegistrationHelper.addModelsForTiers("water_pump", true, true, true, "bronze", "steel", "electric");
        MachineRegistrationHelper.addMachineModel("bronze_boiler", "boiler", MachineCasings.BRICKED_BRONZE, true, false, false);
        MachineRegistrationHelper.addMachineModel("steel_boiler", "boiler", MachineCasings.BRICKED_STEEL, true, false, false);
        SingleBlockSpecialMachines.addDieselGeneratorModel("lv_diesel_generator", CableTier.LV.casing);
        SingleBlockSpecialMachines.addDieselGeneratorModel("mv_diesel_generator", CableTier.MV.casing);
        SingleBlockSpecialMachines.addDieselGeneratorModel("hv_diesel_generator", CableTier.HV.casing);
        MachineRegistrationHelper.addMachineModel("configurable_chest", "", MachineCasings.STEEL_CRATE, false, false, false, false);
        MachineRegistrationHelper.addMachineModel("configurable_tank", "", MachineCasings.CONFIGURABLE_TANK, false, false, false, false);
        MachineRegistrationHelper.addMachineModel("replicator", "replicator", CableTier.SUPERCONDUCTOR.casing, true, false, true, true);
    }

    private static void addDieselGeneratorModel(String id, MachineCasing casing) {
        MachineModelsToGenerate.register(id, new MachineModelProperties.Builder(casing).addOverlay("top", MI.id("block/machines/diesel_generator/overlay_top")).addOverlay("top_active", MI.id("block/machines/diesel_generator/overlay_top_active")).addOverlay("front", MI.id("block/machines/diesel_generator/overlay_front")).addOverlay("front_active", MI.id("block/machines/diesel_generator/overlay_front_active")).addOverlay("output", MI.id("block/overlays/output_energy")).build());
    }

    private static void registerTransformer(CableTier low, CableTier up) {
        String lowToUp = TransformerMachineBlockEntity.getTransformerName(low, up);
        String lowToUpName = TransformerMachineBlockEntity.getTransformerEnglishName(low, up);
        MachineRegistrationHelper.registerMachine(lowToUpName, lowToUp, bet -> new TransformerMachineBlockEntity((BEP)bet, low, up), AbstractStorageMachineBlockEntity::registerEnergyApi);
        String upToLow = TransformerMachineBlockEntity.getTransformerName(up, low);
        String upToLowName = TransformerMachineBlockEntity.getTransformerEnglishName(up, low);
        MachineRegistrationHelper.registerMachine(upToLowName, upToLow, bet -> new TransformerMachineBlockEntity((BEP)bet, up, low), AbstractStorageMachineBlockEntity::registerEnergyApi);
        MachineModelsToGenerate.register(lowToUp, new MachineModelProperties.Builder(up.casing).addOverlay("top", MI.id("block/machines/transformer/overlay_top")).addOverlay("side", MI.id("block/machines/transformer/overlay_side")).addOverlay("output", MI.id("block/overlays/output_energy")).build());
        MachineModelsToGenerate.register(upToLow, new MachineModelProperties.Builder(up.casing).addOverlay("top", MI.id("block/machines/transformer/overlay_top")).addOverlay("side", MI.id("block/overlays/output_energy")).addOverlay("output", MI.id("block/machines/transformer/overlay_side")).noOverlayOnOutputSide().build());
    }

    private static void registerTransformers() {
        record TierPair(CableTier low, CableTier high) {
        }
        HashSet<TierPair> registeredPairs = new HashSet<TierPair>();
        List<CableTier> tiers = CableTier.allTiers();
        for (int i = 0; i < tiers.size() - 1; ++i) {
            TierPair pair = new TierPair(tiers.get(i), tiers.get(i + 1));
            SingleBlockSpecialMachines.registerTransformer(pair.low, pair.high);
            registeredPairs.add(pair);
        }
        List<CableTier> builtinTiers = CableTier.allTiers().stream().filter(x -> x.builtin).toList();
        for (int i = 0; i < builtinTiers.size() - 1; ++i) {
            TierPair pair = new TierPair(builtinTiers.get(i), builtinTiers.get(i + 1));
            if (!registeredPairs.add(pair)) continue;
            SingleBlockSpecialMachines.registerTransformer(pair.low, pair.high);
        }
    }

    private static void registerSteamTurbine(CableTier tier, int eu, int fluidCapacity) {
        String id = tier.name + "_steam_turbine";
        String englishName = tier.shortEnglishName + " Steam Turbine";
        MachineRegistrationHelper.registerMachine(englishName, id, bet -> new GeneratorMachineBlockEntity((BEP)bet, id, true, tier, (long)eu * 100L, fluidCapacity, eu, MIFluids.STEAM, 1L), MachineBlockEntity::registerFluidApi, GeneratorMachineBlockEntity::registerEnergyApi);
        MachineModelsToGenerate.register(id, new MachineModelProperties.Builder(tier.casing).addOverlay("front", MI.id("block/machines/steam_turbine/overlay_front")).addOverlay("front_active", MI.id("block/machines/steam_turbine/overlay_front_active")).addOverlay("output", MI.id("block/overlays/output_energy")).build());
    }

    private static void registerEUStorage() {
        for (CableTier tier : CableTier.allTiers()) {
            String id = tier.name + "_storage_unit";
            String englishName = tier.shortEnglishName + " Storage Unit";
            MachineRegistrationHelper.registerMachine(englishName, id, bet -> new StorageMachineBlockEntity((BEP)bet, tier, id, 100000L * tier.eu), AbstractStorageMachineBlockEntity::registerEnergyApi);
            MachineModelsToGenerate.register(id, new MachineModelProperties.Builder(tier.casing).addOverlay("side", MI.id("block/machines/electric_storage/overlay_side")).addOverlay("output", MI.id("block/overlays/output_energy")).build());
        }
    }
}

