/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.OverclockComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.guicomponents.CraftingMultiblockGui;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import org.jspecify.annotations.Nullable;

public class SteamCraftingMultiblockBlockEntity
extends AbstractCraftingMultiblockBlockEntity {
    private final OverclockComponent overclockComponent;
    private final MachineRecipeType recipeType;
    private boolean steelTier;

    public SteamCraftingMultiblockBlockEntity(BEP bep, ResourceLocation blockId, ShapeTemplate shapeTemplate, MachineRecipeType recipeType, List<OverclockComponent.Catalyst> overclockCatalysts) {
        super(bep, blockId, new OrientationComponent.Params(false, false, false), new ShapeTemplate[]{shapeTemplate});
        this.overclockComponent = new OverclockComponent(overclockCatalysts);
        this.recipeType = recipeType;
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new CraftingMultiblockGui(() -> this.shapeValid.shapeValid, this.crafter::getProgress, this.crafter, this.overclockComponent::getTicks);
        this.registerGuiComponent(guiComponentServerArray);
        this.registerComponents(this.overclockComponent);
    }

    public SteamCraftingMultiblockBlockEntity(BEP bep, String name, ShapeTemplate shapeTemplate, MachineRecipeType recipeType, List<OverclockComponent.Catalyst> overclockCatalysts) {
        this(bep, MI.id(name), shapeTemplate, recipeType, overclockCatalysts);
    }

    @Override
    protected CrafterComponent.Behavior getBehavior() {
        return new Behavior();
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        if (shapeMatcher.isMatchSuccessful()) {
            this.steelTier = false;
            for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
                if (!hatch.upgradesToSteel()) continue;
                this.steelTier = true;
            }
        }
    }

    @Override
    public List<Component> getTooltips() {
        return this.overclockComponent.getTooltips();
    }

    @Override
    public final void tickExtra() {
        this.overclockComponent.tick(this);
    }

    @Override
    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            return this.overclockComponent.onUse(this, player, hand);
        }
        return result;
    }

    private class Behavior
    implements CrafterComponent.Behavior {
        private Behavior() {
        }

        @Override
        public long consumeEu(long max, Simulation simulation) {
            return SteamHelper.consumeSteamEu(SteamCraftingMultiblockBlockEntity.this.inventory.getFluidInputs(), max, simulation);
        }

        @Override
        public MachineRecipeType recipeType() {
            return SteamCraftingMultiblockBlockEntity.this.recipeType;
        }

        @Override
        public long getBaseRecipeEu() {
            return SteamCraftingMultiblockBlockEntity.this.overclockComponent.getRecipeEu(SteamCraftingMultiblockBlockEntity.this.steelTier ? 4 : 2);
        }

        @Override
        public long getMaxRecipeEu() {
            return this.getBaseRecipeEu();
        }

        @Override
        public ServerLevel getCrafterWorld() {
            return (ServerLevel)SteamCraftingMultiblockBlockEntity.this.level;
        }

        @Override
        public @Nullable UUID getOwnerUuid() {
            return SteamCraftingMultiblockBlockEntity.this.placedBy.placerId;
        }
    }
}

