/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.hatches;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.HatchTypes;
import aztech.modern_industrialization.util.FluidHelper;
import java.util.List;
import net.minecraft.network.chat.Component;

public class FluidHatch
extends HatchBlockEntity {
    private final boolean input;
    private final boolean upgradesToSteel;
    private final MIInventory inventory;

    public FluidHatch(BEP bep, MachineGuiParameters guiParams, boolean input, boolean upgradesToSteel, MIInventory inventory) {
        super(bep, guiParams, OrientationComponent.Params.noFacing(false, true));
        this.input = input;
        this.upgradesToSteel = upgradesToSteel;
        this.inventory = inventory;
        this.registerComponents(inventory);
        this.registerGuiComponent(new AutoExtract(this.orientation, input));
    }

    @Override
    public HatchType getHatchType() {
        return this.input ? HatchTypes.FLUID_INPUT : HatchTypes.FLUID_OUTPUT;
    }

    @Override
    public boolean upgradesToSteel() {
        return this.upgradesToSteel;
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void appendFluidInputs(List<ConfigurableFluidStack> list) {
        if (this.input) {
            list.addAll(this.inventory.getFluidStacks());
        }
    }

    @Override
    public void appendFluidOutputs(List<ConfigurableFluidStack> list) {
        if (!this.input) {
            list.addAll(this.inventory.getFluidStacks());
        }
    }

    @Override
    protected void tickTransfer() {
        if (this.orientation.extractFluids) {
            if (this.input) {
                this.inventory.autoInsertFluids(this.level, this.worldPosition, this.orientation.outputDirection);
            } else {
                this.inventory.autoExtractFluids(this.level, this.worldPosition, this.orientation.outputDirection);
            }
        }
    }

    @Override
    public List<Component> getTooltips() {
        return List.of(MITooltips.line(MIText.HatchCapacityFluid).arg(FluidHelper.getFluidAmountLarge(this.inventory.getFluidStacks().getFirst().getCapacity()), t -> t.setStyle(MITooltips.NUMBER_TEXT)).build());
    }
}

