/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.api.machine.component.FluidAccess;
import aztech.modern_industrialization.compat.viewer.ReiDraggable;
import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.BackgroundRenderedSlot;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.UnsupportedOperationInventory;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import org.jspecify.annotations.Nullable;

public class ConfigurableFluidStack
extends AbstractConfigurableStack<Fluid, FluidVariant>
implements FluidAccess {
    private long capacity;

    public ConfigurableFluidStack(long capacity) {
        this.capacity = capacity;
    }

    public static ConfigurableFluidStack standardInputSlot(long capacity) {
        ConfigurableFluidStack stack = new ConfigurableFluidStack(capacity);
        stack.playerInsert = true;
        stack.pipesInsert = true;
        return stack;
    }

    public static ConfigurableFluidStack standardOutputSlot(long capacity) {
        ConfigurableFluidStack stack = new ConfigurableFluidStack(capacity);
        stack.pipesExtract = true;
        return stack;
    }

    public static ConfigurableFluidStack standardIOSlot(long capacity, boolean pipeIO) {
        ConfigurableFluidStack stack = new ConfigurableFluidStack(capacity);
        stack.playerInsert = true;
        if (pipeIO) {
            stack.pipesInsert = true;
            stack.pipesExtract = true;
        }
        return stack;
    }

    public static ConfigurableFluidStack lockedInputSlot(long capacity, Fluid fluid) {
        ConfigurableFluidStack stack = new ConfigurableFluidStack(capacity);
        stack.key = FluidVariant.of(fluid);
        stack.lockedInstance = fluid;
        stack.playerInsert = true;
        stack.playerLockable = false;
        stack.playerLocked = true;
        stack.pipesInsert = true;
        return stack;
    }

    public static ConfigurableFluidStack lockedOutputSlot(long capacity, Fluid fluid) {
        ConfigurableFluidStack stack = new ConfigurableFluidStack(capacity);
        stack.key = FluidVariant.of(fluid);
        stack.lockedInstance = fluid;
        stack.playerLockable = false;
        stack.playerLocked = true;
        stack.pipesExtract = true;
        return stack;
    }

    public ConfigurableFluidStack(ConfigurableFluidStack other) {
        super(other);
        this.capacity = other.capacity;
    }

    public ConfigurableFluidStack(CompoundTag compound, HolderLookup.Provider registries) {
        super(compound, registries);
        this.capacity = compound.getLong("capacity");
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigurableFluidStack that = (ConfigurableFluidStack)o;
        return this.capacity == that.capacity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.capacity);
    }

    public static ArrayList<ConfigurableFluidStack> copyList(List<ConfigurableFluidStack> list) {
        ArrayList<ConfigurableFluidStack> copy = new ArrayList<ConfigurableFluidStack>(list.size());
        for (ConfigurableFluidStack stack : list) {
            copy.add(new ConfigurableFluidStack(stack));
        }
        return copy;
    }

    @Override
    protected FluidVariant getBlankVariant() {
        return FluidVariant.blank();
    }

    @Override
    protected Fluid getEmptyInstance() {
        return Fluids.EMPTY;
    }

    @Override
    protected Registry<Fluid> getRegistry() {
        return BuiltInRegistries.FLUID;
    }

    @Override
    protected FluidVariant readVariantFromNbt(CompoundTag compound, HolderLookup.Provider registries) {
        return FluidVariant.fromNbt(compound, registries);
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    protected long getRemainingCapacityFor(FluidVariant key) {
        return this.getRemainingSpace();
    }

    @Override
    public long getTotalCapacityFor(Fluid instance) {
        return this.capacity;
    }

    @Override
    public void setAmount(long amount) {
        super.setAmount(amount);
        if (amount > this.capacity) {
            throw new IllegalStateException("amount > capacity in the fluid stack");
        }
        if (amount < 0L) {
            throw new IllegalStateException("amount < 0 in the fluid stack");
        }
    }

    public void setCapacity(long capacity) {
        Preconditions.checkArgument((capacity >= 0L ? 1 : 0) != 0, (Object)"Fluid Capacity must be > 0");
        this.capacity = capacity;
        if (this.amount > capacity) {
            this.amount = capacity;
        }
    }

    public long getRemainingSpace() {
        return this.capacity - this.amount;
    }

    @Override
    public CompoundTag toNbt(HolderLookup.Provider registries) {
        CompoundTag tag = super.toNbt(registries);
        tag.putLong("capacity", this.capacity);
        return tag;
    }

    @Override
    public FluidVariant getVariant() {
        return (FluidVariant)this.getResource();
    }

    public class ConfigurableFluidSlot
    extends Slot
    implements ReiDraggable,
    BackgroundRenderedSlot {
        private final Runnable markDirty;

        public ConfigurableFluidSlot(ConfigurableFluidSlot other) {
            this(other.markDirty, other.x, other.y);
            this.index = other.index;
        }

        public ConfigurableFluidSlot(Runnable markDirty, int x, int y) {
            super((Container)new UnsupportedOperationInventory(), -1, x, y);
            this.markDirty = markDirty;
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public boolean mayPickup(Player playerEntity) {
            return false;
        }

        public boolean canInsertFluid(FluidVariant fluid) {
            FluidVariant storedFluid = (FluidVariant)this.getConfStack().getResource();
            return ConfigurableFluidStack.this.playerInsert && ConfigurableFluidStack.this.isResourceAllowedByLock(fluid.getFluid()) && (storedFluid.isBlank() || storedFluid.equals(fluid));
        }

        public boolean canExtractFluid(FluidVariant fluid) {
            return ConfigurableFluidStack.this.playerExtract;
        }

        public ConfigurableFluidStack getConfStack() {
            return ConfigurableFluidStack.this;
        }

        public ItemStack getItem() {
            return ItemStack.EMPTY;
        }

        public void set(ItemStack stack) {
        }

        public void setChanged() {
            this.markDirty.run();
        }

        @Override
        public boolean dragFluid(FluidVariant fluidKey, Simulation simulation) {
            return ConfigurableFluidStack.this.playerLock(fluidKey.getFluid(), simulation);
        }

        @Override
        public boolean dragItem(ItemVariant itemKey, Simulation simulation) {
            return false;
        }

        @Override
        public int getBackgroundU() {
            return ConfigurableFluidStack.this.isPlayerLocked() ? 90 : (ConfigurableFluidStack.this.isMachineLocked() ? 126 : 18);
        }

        public boolean playerInteract(SlotAccess slot, Player player, boolean allowSlotExtract) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)slot.get().getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandlerItem == null) {
                return false;
            }
            FluidTank slotTank = new FluidTank(Ints.saturatedCast((long)ConfigurableFluidStack.this.getCapacity()), fs -> this.canInsertFluid(FluidVariant.of(fs)));
            slotTank.setFluid(ConfigurableFluidStack.this.getVariant().toStack(Ints.saturatedCast((long)ConfigurableFluidStack.this.getAmount())));
            FluidActionResult extractResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)slot.get(), (IFluidHandler)slotTank, (IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            if (extractResult.isSuccess()) {
                slot.set(extractResult.getResult());
                ConfigurableFluidStack.this.setKey(FluidVariant.of(slotTank.getFluid()));
                ConfigurableFluidStack.this.setAmount(slotTank.getFluidAmount());
                return true;
            }
            if (!allowSlotExtract || ConfigurableFluidStack.this.isEmpty() || !this.canExtractFluid(ConfigurableFluidStack.this.getVariant())) {
                return false;
            }
            FluidActionResult insertResult = FluidUtil.tryFillContainerAndStow((ItemStack)slot.get(), (IFluidHandler)slotTank, (IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            if (insertResult.isSuccess()) {
                slot.set(insertResult.getResult());
                ConfigurableFluidStack.this.setKey(FluidVariant.of(slotTank.getFluid()));
                ConfigurableFluidStack.this.setAmount(slotTank.getFluidAmount());
                return true;
            }
            return false;
        }
    }
}

