/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.datagen.model;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.client.datagen.model.UseBlockModelModelBuilder;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class MachineCasingsProvider
extends ModelProvider<BlockModelBuilder> {
    public MachineCasingsProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "modern_industrialization", "machine_casing", BlockModelBuilder::new, existingFileHelper);
    }

    protected void registerModels() {
        for (MachineCasing casing : MachineCasings.registeredCasings.values()) {
            if (casing.imitatedBlock == null) continue;
            this.imitateBlock(casing, casing.imitatedBlock.get());
        }
        this.imitateBlock(CableTier.LV.casing, MIBlock.BASIC_MACHINE_HULL.asBlock());
        this.imitateBlock(CableTier.MV.casing, MIBlock.ADVANCED_MACHINE_HULL.asBlock());
        this.imitateBlock(CableTier.HV.casing, MIBlock.TURBO_MACHINE_HULL.asBlock());
        this.imitateBlock(CableTier.EV.casing, MIBlock.HIGHLY_ADVANCED_MACHINE_HULL.asBlock());
        this.imitateBlock(CableTier.SUPERCONDUCTOR.casing, MIBlock.QUANTUM_MACHINE_HULL.asBlock());
        this.cubeBottomTop(MachineCasings.BRICKED_BRONZE, "block/casings/bricked_bronze", "block/fire_clay_bricks", "block/bronze_machine_casing");
        this.cubeBottomTop(MachineCasings.BRICKED_STEEL, "block/casings/bricked_steel", "block/fire_clay_bricks", "block/steel_machine_casing");
        this.cubeAll(MachineCasings.CONFIGURABLE_TANK, "block/casings/configurable_tank");
        this.cubeAll(MachineCasings.STEEL_CRATE, "block/casings/steel_crate");
    }

    private void imitateBlock(MachineCasing casing, Block block) {
        ((BlockModelBuilder)this.getBuilder(casing.key.toString())).customLoader((bmb, existingFileHelper) -> new UseBlockModelModelBuilder<BlockModelBuilder>(block, (BlockModelBuilder)bmb, (ExistingFileHelper)existingFileHelper));
    }

    private void cubeBottomTop(MachineCasing casing, String side, String bottom, String top) {
        this.cubeBottomTop(casing.key.toString(), MI.id(side), MI.id(bottom), MI.id(top));
    }

    private void cubeAll(MachineCasing casing, String side) {
        this.cubeAll(casing.key.toString(), MI.id(side));
    }

    public String getName() {
        return "Machine Casings";
    }
}

