/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.compat.viewer.usage;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerRecipe;
import aztech.modern_industrialization.client.blocks.forgehammer.ForgeHammerScreen;
import aztech.modern_industrialization.client.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.items.ForgeTool;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class ForgeHammerCategory
extends ViewerCategory<RecipeHolder<ForgeHammerRecipe>> {
    public static final ResourceLocation ID = MI.id("forge_hammer");
    private final int startPointX;
    private final int startPointY;

    protected ForgeHammerCategory() {
        super(RecipeHolder.class, ID, (Component)MIBlock.FORGE_HAMMER.asBlock().getName(), MIBlock.FORGE_HAMMER.asItem().getDefaultInstance(), 150, 40);
        this.startPointX = this.width / 2 - 25;
        this.startPointY = this.height / 2 - 18;
    }

    @Override
    public void buildWorkstations(ViewerCategory.WorkstationConsumer consumer) {
        consumer.accept(MIBlock.FORGE_HAMMER);
    }

    @Override
    public void buildRecipes(RecipeManager recipeManager, RegistryAccess registryAccess, Consumer<RecipeHolder<ForgeHammerRecipe>> consumer) {
        recipeManager.getAllRecipesFor((RecipeType)MIRegistries.FORGE_HAMMER_RECIPE_TYPE.get()).stream().sorted(Comparator.comparing(RecipeHolder::id)).forEach(consumer);
    }

    @Override
    public void buildLayout(RecipeHolder<ForgeHammerRecipe> holder, ViewerCategory.LayoutBuilder builder) {
        ForgeHammerRecipe recipe = (ForgeHammerRecipe)holder.value();
        builder.inputSlot(this.startPointX + 5, this.startPointY + 6).ingredient(recipe.ingredient(), recipe.count(), 1.0f);
        if (recipe.hammerDamage() > 0) {
            builder.inputSlot(this.startPointX - 23, this.startPointY + 6).ingredient(Ingredient.of(ForgeTool.TAG), 1L, 1.0f).removeBackground().markCatalyst();
        }
        builder.outputSlot(this.startPointX + 62, this.startPointY + 6).item(recipe.result());
    }

    @Override
    public void buildWidgets(RecipeHolder<ForgeHammerRecipe> holder, ViewerCategory.WidgetList widgets) {
        ForgeHammerRecipe recipe = (ForgeHammerRecipe)holder.value();
        widgets.arrow(this.startPointX + 27, this.startPointY + 4);
        widgets.texture(ForgeHammerScreen.FORGE_HAMMER_GUI, this.startPointX - 24, this.startPointY + 5, 7, 32, 18, 18);
        MutableComponent text = recipe.hammerDamage() > 0 ? MIText.DurabilityCost.text(recipe.hammerDamage()) : MIText.NoToolRequired.text();
        widgets.secondaryText((Component)text, this.startPointX - 24, 28.0f);
    }

    @Override
    public ResourceLocation getRecipeId(RecipeHolder<ForgeHammerRecipe> recipe) {
        return recipe.id();
    }
}

