/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.impl.TransferApiImpl;
import aztech.modern_industrialization.thirdparty.fabrictransfer.impl.fluid.FluidVariantImpl;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.NonExtendable
public interface FluidVariant
extends TransferVariant<Fluid> {
    public static final Codec<FluidVariant> CODEC = ExtraCodecs.optionalEmptyMap((Codec)FluidStack.fixedAmountCodec((int)1).xmap(FluidVariant::of, fv -> fv.toStack(1))).xmap(o -> o.orElse(FluidVariant.blank()), fv -> fv.isBlank() ? Optional.empty() : Optional.of(fv));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidVariant> STREAM_CODEC = FluidStack.OPTIONAL_STREAM_CODEC.map(FluidVariant::of, fv -> fv.toStack(1));

    public static FluidVariant blank() {
        return FluidVariant.of(Fluids.EMPTY);
    }

    public static FluidVariant of(FluidStack stack) {
        return FluidVariantImpl.of(stack);
    }

    public static FluidVariant of(Fluid fluid) {
        return FluidVariantImpl.of(fluid);
    }

    public boolean matches(FluidStack var1);

    default public Fluid getFluid() {
        return (Fluid)this.getObject();
    }

    public FluidStack toStack(int var1);

    @Override
    default public Tag toNbt(HolderLookup.Provider registries) {
        return (Tag)CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public static FluidVariant fromNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        return CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)TransferApiImpl.LOGGER).error(arg_0)).orElse(FluidVariant.blank());
    }

    @Override
    default public void toPacket(RegistryFriendlyByteBuf buf) {
        STREAM_CODEC.encode((Object)buf, (Object)this);
    }

    public static FluidVariant fromPacket(RegistryFriendlyByteBuf buf) {
        return (FluidVariant)STREAM_CODEC.decode((Object)buf);
    }
}

