/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabrictransfer.api.client.fluid;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariantAttributes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public final class FluidVariantRendering {
    private FluidVariantRendering() {
    }

    public static IClientFluidTypeExtensions getExtensions(FluidVariant variant) {
        return IClientFluidTypeExtensions.of((FluidType)variant.getFluid().getFluidType());
    }

    public static List<Component> getTooltip(FluidVariant fluidVariant) {
        return FluidVariantRendering.getTooltip(fluidVariant, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }

    public static List<Component> getTooltip(FluidVariant fluidVariant, TooltipFlag context) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(FluidVariantAttributes.getName(fluidVariant));
        if (context.isAdvanced()) {
            tooltip.add((Component)Component.literal((String)BuiltInRegistries.FLUID.getKey((Object)fluidVariant.getFluid()).toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    @Nullable
    public static TextureAtlasSprite getSprite(FluidVariant fluidVariant) {
        if (fluidVariant.isBlank()) {
            return null;
        }
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(FluidVariantRendering.getExtensions(fluidVariant).getStillTexture(fluidVariant.toStack(1)));
    }

    public static int getColor(FluidVariant fluidVariant) {
        return FluidVariantRendering.getExtensions(fluidVariant).getTintColor(fluidVariant.toStack(1));
    }

    public static int getColor(FluidVariant fluidVariant, @Nullable BlockAndTintGetter level, BlockPos pos) {
        if (level == null) {
            return FluidVariantRendering.getColor(fluidVariant);
        }
        return FluidVariantRendering.getExtensions(fluidVariant).getTintColor(fluidVariant.getFluid().defaultFluidState(), level, pos);
    }
}

