/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.textures;

import aztech.modern_industrialization.textures.coloramp.IColoramp;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;

public class TextureHelper {
    public static void colorize(NativeImage image, IColoramp colorramp) {
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int color = image.getPixelRGBA(i, j);
                double l = TextureHelper.getLuminance(color);
                int rgb = colorramp.getRGB(l);
                int r = TextureHelper.getRrgb(rgb);
                int g = TextureHelper.getGrgb(rgb);
                int b = TextureHelper.getBrgb(rgb);
                image.setPixelRGBA(i, j, TextureHelper.fromArgb(TextureHelper.getA(color), r, g, b));
            }
        }
    }

    public static void setAlpha(NativeImage image, int alpha) {
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int color = image.getPixelRGBA(i, j);
                int r = TextureHelper.getR(color);
                int g = TextureHelper.getG(color);
                int b = TextureHelper.getB(color);
                image.setPixelRGBA(i, j, TextureHelper.fromArgb(alpha, r, g, b));
            }
        }
    }

    public static void increaseBrightness(NativeImage image, float minBrightness) {
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int color = image.getPixelRGBA(i, j);
                double l = TextureHelper.getLuminance(color);
                int r = TextureHelper.getR(color);
                int g = TextureHelper.getG(color);
                int b = TextureHelper.getB(color);
                int rgb = TextureHelper.inecreaseBrightness(TextureHelper.toRGB(r, g, b), minBrightness);
                r = TextureHelper.getRrgb(rgb);
                g = TextureHelper.getGrgb(rgb);
                b = TextureHelper.getBrgb(rgb);
                image.setPixelRGBA(i, j, TextureHelper.fromArgb(TextureHelper.getA(color), r, g, b));
            }
        }
    }

    public static double getLuminance(int color) {
        return (0.2126 * (double)TextureHelper.getR(color) + 0.7152 * (double)TextureHelper.getG(color) + 0.0722 * (double)TextureHelper.getB(color)) / 255.0;
    }

    public static int mixRGB(int rgb1, int rgb2, double fact) {
        int r1 = TextureHelper.getRrgb(rgb1);
        int r2 = TextureHelper.getRrgb(rgb2);
        int g1 = TextureHelper.getGrgb(rgb1);
        int g2 = TextureHelper.getGrgb(rgb2);
        int b1 = TextureHelper.getBrgb(rgb1);
        int b2 = TextureHelper.getBrgb(rgb2);
        return TextureHelper.toRGB((int)(fact * (double)r1 + (1.0 - fact) * (double)r2), (int)(fact * (double)g1 + (1.0 - fact) * (double)g2), (int)(fact * (double)b1 + (1.0 - fact) * (double)b2));
    }

    public static int setHue(int rgb, float hue) {
        float[] hsbval = new float[3];
        Color.RGBtoHSB(TextureHelper.getRrgb(rgb), TextureHelper.getGrgb(rgb), TextureHelper.getBrgb(rgb), hsbval);
        return 0xFFFFFF & Color.HSBtoRGB(hue, hsbval[1], hsbval[2]);
    }

    public static int setSaturation(int rgb, float sat) {
        float[] hsbval = new float[3];
        Color.RGBtoHSB(TextureHelper.getRrgb(rgb), TextureHelper.getGrgb(rgb), TextureHelper.getBrgb(rgb), hsbval);
        return 0xFFFFFF & Color.HSBtoRGB(hsbval[0], sat, hsbval[2]);
    }

    public static int inecreaseBrightness(int rgb, float minBrightness) {
        float[] hsbval = new float[3];
        Color.RGBtoHSB(TextureHelper.getRrgb(rgb), TextureHelper.getGrgb(rgb), TextureHelper.getBrgb(rgb), hsbval);
        return 0xFFFFFF & Color.HSBtoRGB(hsbval[0], hsbval[1], minBrightness + (1.0f - minBrightness) * hsbval[2]);
    }

    public static int toRGB(int r, int g, int b) {
        return (r << 16) + (g << 8) + b;
    }

    public static int getRrgb(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGrgb(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBrgb(int rgb) {
        return rgb & 0xFF;
    }

    public static void adjustDimensions(List<NativeImage> images) {
        int maxWidth = 0;
        int maxHeight = 0;
        for (NativeImage image : images) {
            maxWidth = Math.max(maxWidth, image.getWidth());
            maxHeight = Math.max(maxHeight, image.getHeight());
        }
        for (int imageIndex = 0; imageIndex < images.size(); ++imageIndex) {
            NativeImage image;
            image = images.get(imageIndex);
            if (maxWidth % image.getWidth() != 0 || maxHeight % image.getHeight() != 0) {
                String error = String.format("Mismatched dimensions, can't adjust. Max: (%d, %d). Current image: (%d, %d).", maxWidth, maxHeight, image.getWidth(), image.getHeight());
                throw new IllegalArgumentException(error);
            }
            int wFactor = maxWidth / image.getWidth();
            int hFactor = maxHeight / image.getHeight();
            if (wFactor == 1 && hFactor == 1) continue;
            NativeImage newImage = new NativeImage(maxWidth, maxHeight, false);
            for (int i = 0; i < maxWidth; ++i) {
                for (int j = 0; j < maxHeight; ++j) {
                    newImage.setPixelRGBA(i, j, image.getPixelRGBA(i / wFactor, j / hFactor));
                }
            }
            images.set(imageIndex, newImage);
        }
    }

    public static NativeImage blend(NativeImage originalSource, NativeImage originalTop) {
        List<NativeImage> images = Arrays.asList(originalSource, originalTop);
        TextureHelper.adjustDimensions(images);
        NativeImage source = images.get(0);
        NativeImage top = images.get(1);
        NativeImage output = new NativeImage(source.getWidth(), source.getHeight(), false);
        for (int i = 0; i < source.getWidth(); ++i) {
            for (int j = 0; j < source.getHeight(); ++j) {
                int sourceColor = source.getPixelRGBA(i, j);
                int topColor = top.getPixelRGBA(i, j);
                double alphaSource = (double)TextureHelper.getA(sourceColor) / 255.0;
                double alphaTop = (double)TextureHelper.getA(topColor) / 255.0;
                double alphaOut = alphaTop + alphaSource * (1.0 - alphaTop);
                BiFunction<Integer, Integer, Integer> mergeAlpha = (sourceValue, topValue) -> (int)(((double)topValue.intValue() * alphaTop + (double)sourceValue.intValue() * alphaSource * (1.0 - alphaTop)) / alphaOut);
                output.setPixelRGBA(i, j, TextureHelper.fromArgb((int)(alphaOut * 255.0), mergeAlpha.apply(TextureHelper.getR(sourceColor), TextureHelper.getR(topColor)), mergeAlpha.apply(TextureHelper.getG(sourceColor), TextureHelper.getG(topColor)), mergeAlpha.apply(TextureHelper.getB(sourceColor), TextureHelper.getB(topColor))));
            }
        }
        return output;
    }

    public static NativeImage tripleTexture(NativeImage im1, NativeImage im2, NativeImage im3) {
        return TextureHelper.tripleTexture(im1, im2, im3, 2, 2);
    }

    public static NativeImage tripleTexture(NativeImage im1, NativeImage im2, NativeImage im3, int up, int down) {
        NativeImage lowerIngot = new NativeImage(im1.getWidth(), im1.getHeight(), true);
        lowerIngot.copyFrom(im1);
        int shiftDown = lowerIngot.getHeight() * up / 16;
        for (int x = 0; x < lowerIngot.getWidth(); ++x) {
            int y = lowerIngot.getHeight();
            while (y-- > 0) {
                if (y >= shiftDown) {
                    lowerIngot.setPixelRGBA(x, y, lowerIngot.getPixelRGBA(x, y - shiftDown));
                    continue;
                }
                lowerIngot.setPixelRGBA(x, y, 0);
            }
        }
        NativeImage upperIngot = new NativeImage(im3.getWidth(), im3.getHeight(), true);
        upperIngot.copyFrom(im3);
        int shiftUp = upperIngot.getHeight() * down / 16;
        for (int x = 0; x < upperIngot.getWidth(); ++x) {
            for (int y = 0; y < upperIngot.getHeight(); ++y) {
                if (y + shiftUp < upperIngot.getHeight()) {
                    upperIngot.setPixelRGBA(x, y, upperIngot.getPixelRGBA(x, y + shiftUp));
                    continue;
                }
                upperIngot.setPixelRGBA(x, y, 0);
            }
        }
        lowerIngot = TextureHelper.blend(lowerIngot, im2);
        lowerIngot = TextureHelper.blend(lowerIngot, upperIngot);
        upperIngot.close();
        return lowerIngot;
    }

    public static void doubleIngot(NativeImage image) {
        NativeImage lowerIngot = new NativeImage(image.getWidth(), image.getHeight(), true);
        lowerIngot.copyFrom(image);
        int shiftDown = lowerIngot.getHeight() * 2 / 16;
        for (int x = 0; x < lowerIngot.getWidth(); ++x) {
            int y = lowerIngot.getHeight();
            while (y-- > 0) {
                if (y >= shiftDown) {
                    lowerIngot.setPixelRGBA(x, y, lowerIngot.getPixelRGBA(x, y - shiftDown));
                    continue;
                }
                lowerIngot.setPixelRGBA(x, y, 0);
            }
        }
        NativeImage upperIngot = new NativeImage(image.getWidth(), image.getHeight(), true);
        upperIngot.copyFrom(image);
        int shiftUp = upperIngot.getHeight() * 2 / 16;
        for (int x = 0; x < upperIngot.getWidth(); ++x) {
            for (int y = 0; y < upperIngot.getHeight(); ++y) {
                if (y + shiftUp < upperIngot.getHeight()) {
                    upperIngot.setPixelRGBA(x, y, upperIngot.getPixelRGBA(x, y + shiftUp));
                    continue;
                }
                upperIngot.setPixelRGBA(x, y, 0);
            }
        }
        lowerIngot = TextureHelper.blend(lowerIngot, upperIngot);
        image.copyFrom(lowerIngot);
        lowerIngot.close();
        upperIngot.close();
    }

    public static int getA(int color) {
        return color >> 24 & 0xFF;
    }

    public static int getR(int color) {
        return color & 0xFF;
    }

    public static int getG(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getB(int color) {
        return color >> 16 & 0xFF;
    }

    public static int fromArgb(int a, double r, double g, double b) {
        return TextureHelper.fromArgb(a, (int)r, (int)g, (int)b);
    }

    public static int fromArgb(int a, int r, int g, int b) {
        return a << 24 | b << 16 | g << 8 | r;
    }

    public static void flip(NativeImage image) {
        int j;
        int i;
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] flipped = new int[width][height];
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                flipped[i][height - j - 1] = image.getPixelRGBA(i, j);
            }
        }
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                image.setPixelRGBA(i, j, flipped[i][j]);
            }
        }
    }

    public static NativeImage copy(NativeImage image) {
        NativeImage copy = new NativeImage(image.getWidth(), image.getHeight(), true);
        copy.copyFrom(image);
        return copy;
    }

    public static int getOverlayTextColor(int rgb) {
        double luminance = TextureHelper.getLuminance(rgb);
        if (luminance < 0.5) {
            return 0xFFFFFF;
        }
        return 0;
    }
}

