/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.gui;

import aztech.modern_industrialization.client.DynamicTooltip;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

class PriorityDisplay
extends AbstractWidget {
    private final Supplier<Integer> priorityGetter;
    private final Font textRenderer;
    private final BooleanSupplier isEnabled;

    public PriorityDisplay(int x, int y, int width, int height, Component message, Supplier<List<Component>> tooltipSupplier, Supplier<Integer> priorityGetter, Font textRenderer, BooleanSupplier isEnabled) {
        super(x, y, width, height, message);
        this.setTooltip(new DynamicTooltip(tooltipSupplier));
        this.priorityGetter = priorityGetter;
        this.textRenderer = textRenderer;
        this.isEnabled = isEnabled;
        this.active = false;
    }

    public Component getMessage() {
        return Component.literal((String)Integer.toString(this.priorityGetter.get()));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        FormattedCharSequence orderedText = this.getMessage().getVisualOrderText();
        guiGraphics.drawString(this.textRenderer, orderedText, this.getX() + this.width / 2 - this.textRenderer.width(orderedText) / 2, this.getY() + (this.height - 8) / 2, this.isEnabled.getAsBoolean() ? 0x404040 : 0x707070, false);
    }
}

