/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.part.TextureGenParams;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.IsotopeFuelParams;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.nuclear.NuclearOrder;
import java.util.List;

public class NuclearFuelPart
implements PartKeyProvider {
    public final Type type;
    public final PartKey key;

    public NuclearFuelPart(Type type) {
        this.key = new PartKey(type.key);
        this.type = type;
    }

    @Override
    public PartKey key() {
        return this.key;
    }

    private PartTemplate of() {
        String englishNameFormatter = switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Fuel Rod";
            case 1 -> "Double Fuel Rod";
            case 2 -> "Quad Fuel Rod";
            case 3 -> "Depleted %s Fuel Rod";
        };
        PartTemplate out = new PartTemplate(englishNameFormatter, this.key).withRegister((partContext, part, itemPath, itemId, itemTag, englishName) -> {
            SortOrder sortOrder = SortOrder.NUCLEAR.create(NuclearOrder.FUEL_ROD).and((Comparable)((Object)partContext.getMaterialName())).and((Comparable)((Object)this.type));
            if (Type.DEPLETED == this.type) {
                MIItem.item(englishName, itemPath, sortOrder);
            } else {
                IsotopeFuelParams params = partContext.get(MaterialProperty.ISOTOPE);
                if (params == null) {
                    throw new IllegalArgumentException("Material %s must be a fuel isotope".formatted(partContext.getMaterialName()));
                }
                NuclearFuel.NuclearFuelParams fuelParams = new NuclearFuel.NuclearFuelParams(10240000 * this.type.size, params.maxTemp, params.tempLimitLow, params.tempLimitHigh, params.neutronsMultiplication, params.directEnergyFactor, this.type.size);
                INeutronBehaviour neutronBehaviour = INeutronBehaviour.of(NuclearConstant.ScatteringType.HEAVY, params, this.type.size);
                NuclearFuel.of(englishName, itemPath, fuelParams, neutronBehaviour, partContext.getMaterialName() + "_fuel_rod_depleted", sortOrder);
            }
        });
        if (this.type == Type.DEPLETED) {
            out = out.withTexture(new TextureGenParams.DepletedNuclear());
        }
        return out;
    }

    public static List<PartTemplate> ofAll() {
        return List.of(MIParts.FUEL_ROD.of(), MIParts.FUEL_ROD_DOUBLE.of(), MIParts.FUEL_ROD_QUAD.of(), MIParts.FUEL_ROD_DEPLETED.of());
    }

    public static enum Type {
        SIMPLE(1, "fuel_rod"),
        DOUBLE(2, "fuel_rod_double"),
        QUAD(4, "fuel_rod_quad"),
        DEPLETED(0, "fuel_rod_depleted");

        public final int size;
        public final String key;

        private Type(int size, String key) {
            this.size = size;
            this.key = key;
        }
    }
}

