/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.GunpowderOverclockGui;
import aztech.modern_industrialization.util.RenderHelper;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class GunpowderOverclockGuiClient
implements GuiComponentClient {
    final GunpowderOverclockGui.Parameters params;
    int remTick;

    public GunpowderOverclockGuiClient(RegistryFriendlyByteBuf buf) {
        this.params = new GunpowderOverclockGui.Parameters(buf.readInt(), buf.readInt());
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(RegistryFriendlyByteBuf buf) {
        this.remTick = buf.readInt();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    public class Renderer
    implements ClientComponentRenderer {
        @Override
        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            if (GunpowderOverclockGuiClient.this.remTick > 0) {
                int px = x + GunpowderOverclockGuiClient.this.params.renderX;
                int py = y + GunpowderOverclockGuiClient.this.params.renderY;
                guiGraphics.blit(MachineScreen.SLOT_ATLAS, px, py, 0, 58, 20, 20);
            }
        }

        @Override
        public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int cursorX, int cursorY) {
            if (GunpowderOverclockGuiClient.this.remTick > 0 && RenderHelper.isPointWithinRectangle(GunpowderOverclockGuiClient.this.params.renderX, GunpowderOverclockGuiClient.this.params.renderY, 20, 20, cursorX - x, cursorY - y)) {
                guiGraphics.renderTooltip(font, Renderer.formatOverclock(GunpowderOverclockGuiClient.this.remTick), cursorX, cursorY);
            }
        }

        public static Component formatOverclock(int remTick) {
            int seconds = remTick / 20;
            int hours = seconds / 3600;
            int minutes = seconds % 3600 / 60;
            String time = String.format("%d", seconds);
            if (hours > 0) {
                time = String.format("%d:%02d:%02d", hours, minutes, seconds % 60);
            } else if (minutes > 0) {
                time = String.format("%d:%02d", minutes, seconds % 60);
            }
            return MIText.GunpowderTime.text(time);
        }
    }
}

