/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.gui;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.ComponentStorage;
import aztech.modern_industrialization.machines.GuiComponentsClient;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.gui.MachineMenuCommon;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class MachineMenuClient
extends MachineMenuCommon {
    public final ComponentStorage<GuiComponentClient> components;

    public static MachineMenuClient create(int syncId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        ArrayList<ConfigurableItemStack> itemStacks = new ArrayList<ConfigurableItemStack>();
        ArrayList<ConfigurableFluidStack> fluidStacks = new ArrayList<ConfigurableFluidStack>();
        CompoundTag tag = buf.readNbt();
        NbtHelper.getList(tag, "items", itemStacks, t -> new ConfigurableItemStack((CompoundTag)t, (HolderLookup.Provider)buf.registryAccess()));
        NbtHelper.getList(tag, "fluids", fluidStacks, t -> new ConfigurableFluidStack((CompoundTag)t, (HolderLookup.Provider)buf.registryAccess()));
        SlotPositions itemPositions = SlotPositions.read((FriendlyByteBuf)buf);
        SlotPositions fluidPositions = SlotPositions.read((FriendlyByteBuf)buf);
        MIInventory inventory = new MIInventory(itemStacks, fluidStacks, itemPositions, fluidPositions);
        ComponentStorage<GuiComponentClient> components = new ComponentStorage<GuiComponentClient>();
        int componentCount = buf.readInt();
        for (int i = 0; i < componentCount; ++i) {
            ResourceLocation id = buf.readResourceLocation();
            components.register((GuiComponentClient[])new GuiComponentClient[]{GuiComponentsClient.get(id).createFromInitialData(buf)});
        }
        MachineGuiParameters guiParams = MachineGuiParameters.read((FriendlyByteBuf)buf);
        return new MachineMenuClient(syncId, playerInventory, inventory, components, guiParams);
    }

    private MachineMenuClient(int syncId, Inventory playerInventory, MIInventory inventory, ComponentStorage<GuiComponentClient> components, MachineGuiParameters guiParams) {
        super(syncId, playerInventory, inventory, guiParams, components);
        this.components = components;
    }

    @Nullable
    public <T extends GuiComponentClient> T getComponent(Class<T> klass) {
        return (T)((GuiComponentClient)this.components.get(klass));
    }

    public boolean stillValid(Player player) {
        return true;
    }

    @Override
    public void readClientComponentSyncData(int componentIndex, RegistryFriendlyByteBuf buf) {
        this.components.get(componentIndex).readCurrentData(buf);
    }
}

