/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.component.InventoryAccess;
import aztech.modern_industrialization.compat.almostunified.AlmostUnifiedFacade;
import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.stats.PlayerStatistics;
import aztech.modern_industrialization.stats.PlayerStatisticsData;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

public class CrafterComponent
implements IComponent.ServerOnly,
CrafterAccess {
    private final MachineProcessCondition.Context conditionContext;
    private final Inventory inventory;
    private final Behavior behavior;
    @Nullable
    private RecipeHolder<MachineRecipe> activeRecipe = null;
    @Nullable
    private ResourceLocation delayedActiveRecipe;
    private long usedEnergy;
    private long recipeEnergy;
    private long recipeMaxEu;
    private int efficiencyTicks;
    private int maxEfficiencyTicks;
    private long previousBaseEu = -1L;
    private long previousMaxEu = -1L;
    private int lastInvHash = 0;
    private int lastForcedTick = 0;

    public CrafterComponent(MachineBlockEntity blockEntity, Inventory inventory, Behavior behavior) {
        this.inventory = inventory;
        this.behavior = behavior;
        this.conditionContext = () -> blockEntity;
    }

    @Override
    public float getProgress() {
        return (float)this.usedEnergy / (float)this.recipeEnergy;
    }

    @Override
    public int getEfficiencyTicks() {
        return this.efficiencyTicks;
    }

    @Override
    public int getMaxEfficiencyTicks() {
        return this.maxEfficiencyTicks;
    }

    @Override
    public boolean hasActiveRecipe() {
        return this.activeRecipe != null;
    }

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public void decreaseEfficiencyTicks() {
        this.efficiencyTicks = Math.max(this.efficiencyTicks - 1, 0);
        this.clearActiveRecipeIfPossible();
    }

    public void increaseEfficiencyTicks(int increment) {
        this.efficiencyTicks = Math.min(this.efficiencyTicks + increment, this.maxEfficiencyTicks);
    }

    @Override
    public long getCurrentRecipeEu() {
        Preconditions.checkArgument((boolean)this.hasActiveRecipe());
        return this.recipeMaxEu;
    }

    @Override
    public long getBaseRecipeEu() {
        Preconditions.checkArgument((boolean)this.hasActiveRecipe());
        return ((MachineRecipe)this.activeRecipe.value()).eu;
    }

    public boolean tickRecipe() {
        boolean isActive;
        if (this.behavior.getCrafterWorld().isClientSide()) {
            throw new IllegalStateException("May not call client side.");
        }
        boolean isEnabled = this.behavior.isEnabled();
        this.loadDelayedActiveRecipe();
        boolean recipeStarted = false;
        if (this.usedEnergy == 0L && isEnabled && this.behavior.consumeEu(1L, Simulation.SIMULATE) == 1L) {
            recipeStarted = this.updateActiveRecipe();
        }
        if (this.activeRecipe != null) {
            this.lastForcedTick = 0;
        }
        long eu = 0L;
        boolean finishedRecipe = false;
        if (this.activeRecipe != null && isEnabled) {
            if (this.usedEnergy > 0L || recipeStarted) {
                this.recipeMaxEu = this.getRecipeMaxEu(((MachineRecipe)this.activeRecipe.value()).eu, this.recipeEnergy, this.efficiencyTicks);
                eu = ((MachineRecipe)this.activeRecipe.value()).conditionsMatch(this.conditionContext) ? this.behavior.consumeEu(Math.min(this.recipeMaxEu, this.recipeEnergy - this.usedEnergy), Simulation.ACT) : 0L;
                isActive = eu > 0L;
                this.usedEnergy += eu;
                if (this.usedEnergy == this.recipeEnergy) {
                    this.putItemOutputs((MachineRecipe)this.activeRecipe.value(), false, false);
                    this.putFluidOutputs((MachineRecipe)this.activeRecipe.value(), false, false);
                    this.clearLocks();
                    this.usedEnergy = 0L;
                    finishedRecipe = true;
                    this.behavior.onCraft();
                }
            } else if (this.behavior.isOverdriving()) {
                eu = ((MachineRecipe)this.activeRecipe.value()).conditionsMatch(this.conditionContext) ? this.behavior.consumeEu(this.recipeMaxEu, Simulation.ACT) : 0L;
                isActive = eu > 0L;
            } else {
                isActive = false;
            }
        } else {
            isActive = false;
        }
        if (this.activeRecipe != null && (this.previousBaseEu != this.behavior.getBaseRecipeEu() || this.previousMaxEu != this.behavior.getMaxRecipeEu())) {
            this.previousBaseEu = this.behavior.getBaseRecipeEu();
            this.previousMaxEu = this.behavior.getMaxRecipeEu();
            this.maxEfficiencyTicks = this.getRecipeMaxEfficiencyTicks((MachineRecipe)this.activeRecipe.value());
            this.efficiencyTicks = Math.min(this.efficiencyTicks, this.maxEfficiencyTicks);
        }
        if (finishedRecipe) {
            if (this.efficiencyTicks < this.maxEfficiencyTicks) {
                ++this.efficiencyTicks;
            }
        } else if (eu < this.recipeMaxEu && this.efficiencyTicks > 0) {
            --this.efficiencyTicks;
        }
        this.clearActiveRecipeIfPossible();
        return isActive;
    }

    private void clearActiveRecipeIfPossible() {
        if (this.efficiencyTicks == 0 && this.usedEnergy == 0L) {
            this.activeRecipe = null;
        }
    }

    public boolean tryContinueRecipe() {
        this.loadDelayedActiveRecipe();
        if (this.activeRecipe != null) {
            if (this.putItemOutputs((MachineRecipe)this.activeRecipe.value(), true, false) && this.putFluidOutputs((MachineRecipe)this.activeRecipe.value(), true, false)) {
                this.putItemOutputs((MachineRecipe)this.activeRecipe.value(), true, true);
                this.putFluidOutputs((MachineRecipe)this.activeRecipe.value(), true, true);
            } else {
                return false;
            }
        }
        return true;
    }

    private void loadDelayedActiveRecipe() {
        if (this.delayedActiveRecipe != null) {
            this.activeRecipe = this.behavior.recipeType().getRecipe(this.behavior.getCrafterWorld(), this.delayedActiveRecipe);
            this.delayedActiveRecipe = null;
            if (this.activeRecipe == null) {
                this.efficiencyTicks = 0;
                this.usedEnergy = 0L;
            }
        }
    }

    private boolean updateActiveRecipe() {
        for (RecipeHolder<MachineRecipe> recipe : this.getRecipes()) {
            if (this.behavior.banRecipe((MachineRecipe)recipe.value()) || !this.tryStartRecipe((MachineRecipe)recipe.value())) continue;
            if (this.activeRecipe != recipe || this.efficiencyTicks == 0) {
                this.maxEfficiencyTicks = this.getRecipeMaxEfficiencyTicks((MachineRecipe)recipe.value());
            }
            this.activeRecipe = recipe;
            this.usedEnergy = 0L;
            this.recipeEnergy = ((MachineRecipe)recipe.value()).getTotalEu();
            this.recipeMaxEu = this.getRecipeMaxEu(((MachineRecipe)recipe.value()).eu, this.recipeEnergy, this.efficiencyTicks);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Iterable<RecipeHolder<MachineRecipe>> getRecipes() {
        if (this.efficiencyTicks > 0) {
            return Collections.singletonList(this.activeRecipe);
        }
        int currentHash = this.inventory.hash();
        if (currentHash == this.lastInvHash) {
            if (this.lastForcedTick != 0) {
                --this.lastForcedTick;
                return Collections.emptyList();
            }
            this.lastForcedTick = 100;
        } else {
            this.lastInvHash = currentHash;
        }
        ServerLevel serverWorld = this.behavior.getCrafterWorld();
        MachineRecipeType recipeType = this.behavior.recipeType();
        ArrayList<RecipeHolder<MachineRecipe>> recipes = new ArrayList<RecipeHolder<MachineRecipe>>(recipeType.getFluidOnlyRecipes(serverWorld));
        Iterator<ConfigurableItemStack> iterator = this.inventory.getItemInputs().iterator();
        while (iterator.hasNext()) {
            ConfigurableItemStack stack = iterator.next();
            if (stack.isEmpty()) continue;
            recipes.addAll(recipeType.getMatchingRecipes(serverWorld, ((ItemVariant)stack.getResource()).getItem()));
        }
        return recipes;
    }

    private boolean tryStartRecipe(MachineRecipe recipe) {
        if (this.takeItemInputs(recipe, true) && this.takeFluidInputs(recipe, true) && this.putItemOutputs(recipe, true, false) && this.putFluidOutputs(recipe, true, false) && recipe.conditionsMatch(this.conditionContext)) {
            this.takeItemInputs(recipe, false);
            this.takeFluidInputs(recipe, false);
            this.putItemOutputs(recipe, true, true);
            this.putFluidOutputs(recipe, true, true);
            return true;
        }
        return false;
    }

    private long getRecipeMaxEu(long recipeEu, long totalEu, int efficiencyTicks) {
        long baseEu = Math.max(this.behavior.getBaseRecipeEu(), recipeEu);
        long overclockedEu = baseEu + (long)efficiencyTicks * totalEu / 600L;
        return Math.min(totalEu, Math.min(overclockedEu, this.behavior.getMaxRecipeEu()));
    }

    private int getRecipeMaxEfficiencyTicks(MachineRecipe recipe) {
        long eu = recipe.eu;
        long totalEu = recipe.getTotalEu();
        int ticks = 0;
        while (this.getRecipeMaxEu(eu, totalEu, ticks) != Math.min(this.behavior.getMaxRecipeEu(), totalEu)) {
            ++ticks;
        }
        return ticks;
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLong("usedEnergy", this.usedEnergy);
        tag.putLong("recipeEnergy", this.recipeEnergy);
        tag.putLong("recipeMaxEu", this.recipeMaxEu);
        if (this.activeRecipe != null) {
            tag.putString("activeRecipe", this.activeRecipe.id().toString());
        } else if (this.delayedActiveRecipe != null) {
            tag.putString("activeRecipe", this.delayedActiveRecipe.toString());
        }
        tag.putInt("efficiencyTicks", this.efficiencyTicks);
        tag.putInt("maxEfficiencyTicks", this.maxEfficiencyTicks);
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.usedEnergy = tag.getInt("usedEnergy");
        this.recipeEnergy = tag.getInt("recipeEnergy");
        this.recipeMaxEu = tag.getInt("recipeMaxEu");
        ResourceLocation resourceLocation = this.delayedActiveRecipe = tag.contains("activeRecipe") ? ResourceLocation.parse((String)tag.getString("activeRecipe")) : null;
        if (this.delayedActiveRecipe == null && this.usedEnergy > 0L) {
            this.usedEnergy = 0L;
            MI.LOGGER.error("Had to set the usedEnergy of CrafterComponent to 0, but that should never happen!");
        }
        this.efficiencyTicks = tag.getInt("efficiencyTicks");
        this.maxEfficiencyTicks = tag.getInt("maxEfficiencyTicks");
    }

    protected boolean takeItemInputs(MachineRecipe recipe, boolean simulate) {
        List<ConfigurableItemStack> baseList = this.inventory.getItemInputs();
        List<ConfigurableItemStack> stacks = simulate ? ConfigurableItemStack.copyList(baseList) : baseList;
        boolean ok = true;
        for (MachineRecipe.ItemInput input : recipe.itemInputs) {
            if (!simulate && input.probability() < 1.0f && ThreadLocalRandom.current().nextFloat() >= input.probability()) continue;
            int remainingAmount = input.amount();
            for (ConfigurableItemStack stack : stacks) {
                if (stack.getAmount() <= 0L || !((ItemVariant)stack.getResource()).test((Predicate<ItemStack>)input.ingredient())) continue;
                int taken = Math.min((int)stack.getAmount(), remainingAmount);
                if (taken > 0 && !simulate) {
                    this.behavior.getStatsOrDummy().addUsedItems((ItemLike)((ItemVariant)stack.getResource()).getItem(), taken);
                }
                stack.decrement(taken);
                if ((remainingAmount -= taken) != 0) continue;
                break;
            }
            if (remainingAmount <= 0) continue;
            ok = false;
        }
        return ok;
    }

    protected boolean takeFluidInputs(MachineRecipe recipe, boolean simulate) {
        List<ConfigurableFluidStack> baseList = this.inventory.getFluidInputs();
        List<ConfigurableFluidStack> stacks = simulate ? ConfigurableFluidStack.copyList(baseList) : baseList;
        boolean ok = true;
        for (MachineRecipe.FluidInput input : recipe.fluidInputs) {
            if (!simulate && input.probability() < 1.0f && ThreadLocalRandom.current().nextFloat() >= input.probability()) continue;
            long remainingAmount = input.amount();
            for (ConfigurableFluidStack stack : stacks) {
                if (!this.fluidIngredientMatch((FluidVariant)stack.getResource(), input.fluid())) continue;
                long taken = Math.min(remainingAmount, stack.getAmount());
                if (taken > 0L && !simulate) {
                    this.behavior.getStatsOrDummy().addUsedFluids(((FluidVariant)stack.getResource()).getFluid(), taken);
                }
                stack.decrement(taken);
                if ((remainingAmount -= taken) != 0L) continue;
                break;
            }
            if (remainingAmount <= 0L) continue;
            ok = false;
        }
        return ok;
    }

    private boolean fluidIngredientMatch(FluidVariant resource, FluidIngredient ingredient) {
        if (ingredient.isSimple()) {
            for (FluidStack stack : ingredient.getStacks()) {
                if (!resource.equals(FluidVariant.of(stack.getFluid()))) continue;
                return true;
            }
            return false;
        }
        return ingredient.test(resource.toStack(1));
    }

    protected boolean putItemOutputs(MachineRecipe recipe, boolean simulate, boolean toggleLock) {
        List<ConfigurableItemStack> baseList = this.inventory.getItemOutputs();
        List<ConfigurableItemStack> stacks = simulate ? ConfigurableItemStack.copyList(baseList) : baseList;
        ArrayList<Integer> locksToToggle = new ArrayList<Integer>();
        ArrayList<Item> lockItems = new ArrayList<Item>();
        boolean ok = true;
        for (MachineRecipe.ItemOutput output : recipe.itemOutputs) {
            float randFloat;
            if (output.probability() < 1.0f && (simulate || (randFloat = ThreadLocalRandom.current().nextFloat()) > output.probability())) continue;
            int remainingAmount = output.amount();
            block1: for (int loopRun = 0; loopRun < 2; ++loopRun) {
                int stackId = 0;
                for (ConfigurableItemStack stack : stacks) {
                    ++stackId;
                    ItemVariant key = (ItemVariant)stack.getResource();
                    if (!key.equals(output.variant()) && !key.isBlank()) continue;
                    int remainingCapacity = simulate || output.probability() < 1.0f ? (int)stack.getRemainingCapacityFor(output.variant()) : output.variant().getMaxStackSize() - (int)stack.getAmount();
                    int ins = Math.min(remainingAmount, remainingCapacity);
                    if (ins > 0) {
                        if (key.isBlank()) {
                            if ((stack.isMachineLocked() || stack.isPlayerLocked() || loopRun == 1) && stack.isValid(output.getStack())) {
                                stack.setAmount(ins);
                                stack.setKey(output.variant());
                            } else {
                                ins = 0;
                            }
                        } else {
                            stack.increment(ins);
                        }
                    }
                    remainingAmount -= ins;
                    if (ins > 0) {
                        locksToToggle.add(stackId - 1);
                        lockItems.add(output.variant().getItem());
                        if (!simulate) {
                            this.behavior.getStatsOrDummy().addProducedItems((Level)this.behavior.getCrafterWorld(), (ItemLike)output.variant().getItem(), ins);
                        }
                    }
                    if (remainingAmount != 0) continue;
                    continue block1;
                }
            }
            if (remainingAmount <= 0) continue;
            ok = false;
        }
        if (toggleLock) {
            for (int i = 0; i < locksToToggle.size(); ++i) {
                baseList.get((Integer)locksToToggle.get(i)).enableMachineLock((Item)lockItems.get(i));
            }
        }
        return ok;
    }

    protected boolean putFluidOutputs(MachineRecipe recipe, boolean simulate, boolean toggleLock) {
        int i;
        List<ConfigurableFluidStack> baseList = this.inventory.getFluidOutputs();
        List<ConfigurableFluidStack> stacks = simulate ? ConfigurableFluidStack.copyList(baseList) : baseList;
        ArrayList<Integer> locksToToggle = new ArrayList<Integer>();
        ArrayList<Fluid> lockFluids = new ArrayList<Fluid>();
        boolean ok = true;
        block0: for (i = 0; i < Math.min(recipe.fluidOutputs.size(), this.behavior.getMaxFluidOutputs()); ++i) {
            float randFloat;
            MachineRecipe.FluidOutput output = recipe.fluidOutputs.get(i);
            if (output.probability() < 1.0f && (simulate || (randFloat = ThreadLocalRandom.current().nextFloat()) > output.probability())) continue;
            for (int tries = 0; tries < 2; ++tries) {
                for (int j = 0; j < stacks.size(); ++j) {
                    FluidVariant outputKey;
                    ConfigurableFluidStack stack = stacks.get(j);
                    if (!stack.isResourceAllowedByLock(outputKey = FluidVariant.of(output.fluid())) || (tries != 1 || !stack.isResourceBlank()) && !((FluidVariant)stack.getResource()).equals(outputKey)) continue;
                    long inserted = Math.min(output.amount(), stack.getRemainingSpace());
                    if (inserted > 0L) {
                        stack.setKey(outputKey);
                        stack.increment(inserted);
                        locksToToggle.add(j);
                        lockFluids.add(output.fluid());
                        if (!simulate) {
                            this.behavior.getStatsOrDummy().addProducedFluids(output.fluid(), inserted);
                        }
                    }
                    if (inserted >= output.amount()) continue block0;
                    ok = false;
                    continue block0;
                }
                if (tries != 1) continue;
                ok = false;
            }
        }
        if (toggleLock) {
            for (i = 0; i < locksToToggle.size(); ++i) {
                baseList.get((Integer)locksToToggle.get(i)).enableMachineLock((Fluid)lockFluids.get(i));
            }
        }
        return ok;
    }

    protected void clearLocks() {
        for (ConfigurableItemStack configurableItemStack : this.inventory.getItemOutputs()) {
            if (!configurableItemStack.isMachineLocked()) continue;
            configurableItemStack.disableMachineLock();
        }
        for (ConfigurableFluidStack configurableFluidStack : this.inventory.getFluidOutputs()) {
            if (!configurableFluidStack.isMachineLocked()) continue;
            configurableFluidStack.disableMachineLock();
        }
    }

    private static <T, K extends TransferVariant<T>, S extends AbstractConfigurableStack<T, K>> void handleLocking(List<S> stacks, com.google.common.base.Predicate<T> matchesRecipe, long requiredAmount, Supplier<@Nullable T> lockTarget) {
        for (AbstractConfigurableStack stack : stacks) {
            if (stack.getLockedInstance() == null || !matchesRecipe.apply(stack.getLockedInstance()) || (requiredAmount -= stack.getTotalCapacityFor(stack.getLockedInstance())) > 0L) continue;
            return;
        }
        Object newLockedInstance = lockTarget.get();
        if (newLockedInstance == null) {
            return;
        }
        AbstractConfigurableStack.playerLockNoOverride(newLockedInstance, requiredAmount, stacks);
    }

    public void lockRecipe(ResourceLocation recipeId, net.minecraft.world.entity.player.Inventory inventory) {
        Optional<RecipeHolder> optionalMachineRecipe = this.behavior.recipeType().getRecipesWithCache(this.behavior.getCrafterWorld()).stream().filter(recipe -> recipe.id().equals((Object)recipeId)).findFirst();
        if (optionalMachineRecipe.isEmpty()) {
            return;
        }
        RecipeHolder recipe2 = optionalMachineRecipe.get();
        for (MachineRecipe.ItemInput itemInput : ((MachineRecipe)recipe2.value()).itemInputs) {
            CrafterComponent.handleLocking(this.inventory.getItemInputs(), item -> itemInput.matches(new ItemStack((ItemLike)item)), itemInput.amount(), () -> {
                Item targetItem;
                for (int i = 0; i < inventory.getContainerSize(); ++i) {
                    ItemStack playerStack = inventory.getItem(i);
                    if (playerStack.isEmpty() || !itemInput.matches(new ItemStack((ItemLike)playerStack.getItem()))) continue;
                    return playerStack.getItem();
                }
                List<Item> inputItems = itemInput.getInputItems();
                if (!inputItems.isEmpty() && (targetItem = AlmostUnifiedFacade.INSTANCE.getTargetItem((ItemLike)inputItems.getFirst())) != null) {
                    return targetItem;
                }
                for (Item item : inputItems) {
                    ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
                    if (!id.getNamespace().equals("modern_industrialization")) continue;
                    return item;
                }
                if (inputItems.size() == 1) {
                    return inputItems.get(0);
                }
                return null;
            });
        }
        for (MachineRecipe.ItemOutput itemOutput : ((MachineRecipe)recipe2.value()).itemOutputs) {
            CrafterComponent.handleLocking(this.inventory.getItemOutputs(), item -> itemOutput.variant().isOf(item), itemOutput.amount(), itemOutput.variant()::getItem);
        }
        for (MachineRecipe.FluidInput fluidInput : ((MachineRecipe)recipe2.value()).fluidInputs) {
            CrafterComponent.handleLocking(this.inventory.getFluidInputs(), fluid -> fluidInput.fluid().test(new FluidStack(fluid, 1)), fluidInput.amount(), () -> {
                for (int i = 0; i < inventory.getContainerSize(); ++i) {
                    FluidStack playerStack = FluidUtil.getFluidContained((ItemStack)inventory.getItem(i)).orElse(FluidStack.EMPTY);
                    if (playerStack.isEmpty() || !fluidInput.fluid().test(new FluidStack(playerStack.getFluid(), 1))) continue;
                    return playerStack.getFluid();
                }
                List<Fluid> inputFluids = fluidInput.getInputFluids();
                for (Fluid fluid : inputFluids) {
                    ResourceLocation id = BuiltInRegistries.FLUID.getKey((Object)fluid);
                    if (!id.getNamespace().equals("modern_industrialization")) continue;
                    return fluid;
                }
                if (inputFluids.size() == 1) {
                    return inputFluids.get(0);
                }
                return null;
            });
        }
        for (MachineRecipe.FluidOutput fluidOutput : ((MachineRecipe)recipe2.value()).fluidOutputs) {
            CrafterComponent.handleLocking(this.inventory.getFluidOutputs(), fluid -> fluidOutput.fluid() == fluid, fluidOutput.amount(), fluidOutput::fluid);
        }
        if (((MachineRecipe)recipe2.value()).itemInputs.size() > 0 || ((MachineRecipe)recipe2.value()).itemOutputs.size() > 0) {
            CrafterComponent.lockAll(this.inventory.getItemInputs());
            CrafterComponent.lockAll(this.inventory.getItemOutputs());
        }
        if (((MachineRecipe)recipe2.value()).fluidInputs.size() > 0 || ((MachineRecipe)recipe2.value()).fluidOutputs.size() > 0) {
            CrafterComponent.lockAll(this.inventory.getFluidInputs());
            CrafterComponent.lockAll(this.inventory.getFluidOutputs());
        }
    }

    private static void lockAll(List<? extends AbstractConfigurableStack<?, ?>> stacks) {
        for (AbstractConfigurableStack<?, ?> stack : stacks) {
            if (!stack.isEmpty() || stack.getLockedInstance() != null) continue;
            stack.togglePlayerLock();
        }
    }

    public static interface Inventory
    extends InventoryAccess {
        public List<ConfigurableItemStack> getItemInputs();

        public List<ConfigurableItemStack> getItemOutputs();

        public List<ConfigurableFluidStack> getFluidInputs();

        public List<ConfigurableFluidStack> getFluidOutputs();

        public int hash();
    }

    public static interface Behavior {
        default public boolean isEnabled() {
            return true;
        }

        public long consumeEu(long var1, Simulation var3);

        default public boolean banRecipe(MachineRecipe recipe) {
            return (long)recipe.eu > this.getMaxRecipeEu();
        }

        public MachineRecipeType recipeType();

        public long getBaseRecipeEu();

        public long getMaxRecipeEu();

        default public boolean isOverdriving() {
            return false;
        }

        default public void onCraft() {
        }

        public ServerLevel getCrafterWorld();

        default public int getMaxFluidOutputs() {
            return Integer.MAX_VALUE;
        }

        @Nullable
        public UUID getOwnerUuid();

        default public PlayerStatistics getStatsOrDummy() {
            UUID uuid = this.getOwnerUuid();
            if (uuid == null) {
                return PlayerStatistics.DUMMY;
            }
            return PlayerStatisticsData.get(this.getCrafterWorld().getServer()).get(uuid);
        }
    }
}

