/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelTooltipData;
import aztech.modern_industrialization.items.ItemContainingItemHelper;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import dev.technici4n.grandpower.api.ISimpleEnergyItem;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.Optional;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PortableStorageUnit
extends Item
implements ItemContainingItemHelper {
    public static final Reference2LongMap<Item> CAPACITY_PER_BATTERY = new Reference2LongOpenHashMap();
    private static final int MAX_BATTERY_COUNT = 10000;

    public PortableStorageUnit(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public void onChange(ItemStack stack) {
        this.setStoredEnergy(stack, Math.min(this.getEnergyCapacity(stack), this.getStoredEnergy(stack)));
    }

    public long getEnergyCapacity(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return 0L;
        }
        return CAPACITY_PER_BATTERY.getLong((Object)((ItemVariant)this.getResource(stack)).getItem()) * this.getAmount(stack);
    }

    public long getEnergyMaxInput(ItemStack stack) {
        return Long.MAX_VALUE;
    }

    public long getEnergyMaxOutput(ItemStack stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public StorageBehaviour<ItemVariant> getBehaviour() {
        return new StorageBehaviour<ItemVariant>(this){

            @Override
            public long getCapacityForResource(ItemVariant resource) {
                return 10000L;
            }

            @Override
            public boolean canInsert(ItemVariant maybeBattery) {
                return CAPACITY_PER_BATTERY.containsKey((Object)maybeBattery.getItem());
            }
        };
    }

    public boolean overrideStackedOnOther(ItemStack stackBarrel, Slot slot, ClickAction clickType, Player player) {
        return this.handleStackedOnOther(stackBarrel, slot, clickType, player);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        return this.handleOtherStackedOnMe(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (!this.isEmpty(stack)) {
            return Optional.of(new BarrelTooltipData((ItemVariant)this.getResource(stack), this.getAmount(stack), 10000L, false));
        }
        return Optional.empty();
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getEnergyCapacity(stack) > 0L;
    }

    public int getBarWidth(ItemStack stack) {
        if (this.getEnergyCapacity(stack) > 0L) {
            return (int)Math.round((double)this.getStoredEnergy(stack) / (double)this.getEnergyCapacity(stack) * 13.0);
        }
        return 0;
    }

    public long getStoredEnergy(ItemStack stack) {
        return ISimpleEnergyItem.getStoredEnergyUnchecked((ItemStack)stack, MIComponents.ENERGY.get());
    }

    public void setStoredEnergy(ItemStack stack, long newAmount) {
        ISimpleEnergyItem.setStoredEnergyUnchecked((ItemStack)stack, MIComponents.ENERGY.get(), (long)newAmount);
    }
}

