/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.inventory.IConfigurableSlot;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class SlotConfig {
    private final boolean playerLockable;
    private final boolean playerInsert;
    private final boolean playerExtract;
    private final boolean pipesInsert;
    private final boolean pipesExtract;

    SlotConfig(boolean playerLockable, boolean playerInsert, boolean playerExtract, boolean pipesInsert, boolean pipesExtract) {
        this.playerLockable = playerLockable;
        this.playerInsert = playerInsert;
        this.playerExtract = playerExtract;
        this.pipesInsert = pipesInsert;
        this.pipesExtract = pipesExtract;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotConfig that = (SlotConfig)o;
        return this.playerLockable == that.playerLockable && this.playerInsert == that.playerInsert && this.playerExtract == that.playerExtract && this.pipesInsert == that.pipesInsert && this.pipesExtract == that.pipesExtract;
    }

    public int hashCode() {
        return Objects.hash(this.playerLockable, this.playerInsert, this.playerExtract, this.pipesInsert, this.pipesExtract);
    }

    public static <T extends IConfigurableSlot> void readSlotList(List<T> oldList, List<T> newList) {
        HashMap<SlotConfig, ArrayDeque> configMatches = new HashMap<SlotConfig, ArrayDeque>();
        for (int i = 0; i < oldList.size(); ++i) {
            configMatches.computeIfAbsent(((IConfigurableSlot)oldList.get(i)).getConfig(), c -> new ArrayDeque()).addLast(i);
        }
        for (IConfigurableSlot newSlot : newList) {
            ArrayDeque positions = (ArrayDeque)configMatches.get(newSlot.getConfig());
            if (positions == null || positions.size() <= 0) continue;
            oldList.set((Integer)positions.pollFirst(), newSlot);
        }
    }
}

