/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIStorage;
import aztech.modern_industrialization.inventory.WhitelistedItemStorage;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class MIItemStorage
extends MIStorage<Item, ItemVariant, ConfigurableItemStack> {
    public final IItemHandler itemHandler = new ItemHandler();

    public MIItemStorage(List<ConfigurableItemStack> stacks) {
        super(stacks, false);
    }

    public class ItemHandler
    implements IItemHandler,
    WhitelistedItemStorage {
        public int getSlots() {
            return MIItemStorage.this.stacks.size();
        }

        public ItemStack getStackInSlot(int slot) {
            return ((ConfigurableItemStack)MIItemStorage.this.stacks.get(slot)).getVariant().toStack(Ints.saturatedCast((long)((ConfigurableItemStack)MIItemStorage.this.stacks.get(slot)).getAmount()));
        }

        public ItemStack insertItem(int slot, ItemStack item, boolean simulate) {
            if (item.isEmpty()) {
                return ItemStack.EMPTY;
            }
            ConfigurableItemStack stack = (ConfigurableItemStack)MIItemStorage.this.stacks.get(slot);
            if (!stack.pipesInsert) {
                return item;
            }
            ItemVariant resource = ItemVariant.of(item);
            boolean canInsert = stack.getAmount() == 0L ? stack.isResourceAllowedByLock(resource) : ((ItemVariant)stack.getResource()).equals(resource);
            if (canInsert) {
                long inserted = Math.min((long)item.getCount(), stack.getRemainingCapacityFor(resource));
                if (inserted > 0L && !simulate) {
                    stack.setKey(resource);
                    stack.increment(inserted);
                }
                return inserted == (long)item.getCount() ? ItemStack.EMPTY : resource.toStack((int)((long)item.getCount() - inserted));
            }
            return item;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0) {
                return ItemStack.EMPTY;
            }
            try (Transaction tx = Transaction.hackyOpen();){
                ItemVariant variant = ((ConfigurableItemStack)MIItemStorage.this.stacks.get(slot)).getVariant();
                if (variant.isBlank()) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    return itemStack;
                }
                long result = ((ConfigurableItemStack)MIItemStorage.this.stacks.get(slot)).extract(variant, (long)amount, (TransactionContext)tx);
                if (result > 0L && !simulate) {
                    tx.commit();
                }
                ItemStack itemStack = result == 0L ? ItemStack.EMPTY : variant.toStack((int)result);
                return itemStack;
            }
        }

        public int getSlotLimit(int slot) {
            return (int)((ConfigurableItemStack)MIItemStorage.this.stacks.get(slot)).getCapacity();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return ((ConfigurableItemStack)MIItemStorage.this.stacks.get(slot)).isResourceAllowedByLock(stack.getItem());
        }

        @Override
        public boolean currentlyWhitelisted() {
            for (ConfigurableItemStack stack : MIItemStorage.this.stacks) {
                if (!stack.pipesInsert || stack.getLockedInstance() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public void getWhitelistedItems(Set<Item> whitelist) {
            for (ConfigurableItemStack stack : MIItemStorage.this.stacks) {
                if (!stack.pipesInsert || stack.getLockedInstance() == Items.AIR) continue;
                whitelist.add((Item)stack.getLockedInstance());
            }
        }
    }
}

