/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.client.screen.MIHandledScreen;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.compat.viewer.impl.jei.MIGhostIngredientHandler;
import aztech.modern_industrialization.compat.viewer.impl.jei.MachineGuiContainerHandler;
import aztech.modern_industrialization.compat.viewer.impl.jei.MachineSlotLockingHandler;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import java.util.Map;
import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;

@REIPluginCompatIgnore
@JeiPlugin
public class ManualPluginJei
implements IModPlugin {
    private static final ResourceLocation ID = MI.id("manual");
    private IJeiRuntime jeiRuntime;

    private RecipeType<RecipeHolder<MachineRecipe>> getMachineCategory(ResourceLocation category) {
        return RecipeType.create((String)category.getNamespace(), (String)category.getPath(), RecipeHolder.class);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.jeiRuntime = jeiRuntime;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper helper = registration.getTransferHelper();
        for (Map.Entry<ResourceLocation, MachineCategoryParams> entry : ReiMachineRecipes.categories.entrySet()) {
            RecipeType<RecipeHolder<MachineRecipe>> type = this.getMachineCategory(entry.getKey());
            registration.addRecipeTransferHandler((IRecipeTransferHandler)new MachineSlotLockingHandler(helper, () -> this.jeiRuntime, type), type);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(MIHandledScreen.class, (IGhostIngredientHandler)new MIGhostIngredientHandler());
        registration.addGuiContainerHandler(MachineScreen.class, (IGuiContainerHandler)new MachineGuiContainerHandler(registration.getJeiHelpers().getIngredientManager(), () -> this.jeiRuntime));
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

