/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.forgehammer;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ForgeHammerBlock
extends Block {
    private VoxelShape shape;
    private int[] part_height = new int[]{4, 1, 5, 5};
    private int[] part_width = new int[]{14, 10, 8, 14};

    public ForgeHammerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        int i;
        VoxelShape[] parts = new VoxelShape[this.part_height.length];
        float currentY = 0.0f;
        for (i = 0; i < this.part_height.length; ++i) {
            float o = (float)(16 - this.part_width[i]) / 32.0f;
            float e = o + (float)this.part_width[i] / 16.0f;
            parts[i] = Shapes.box((double)o, (double)currentY, (double)o, (double)e, (double)(currentY + (float)this.part_height[i] / 16.0f), (double)e);
            currentY += (float)this.part_height[i] / 16.0f;
        }
        this.shape = parts[0];
        for (i = 1; i < this.part_height.length; ++i) {
            this.shape = Shapes.or((VoxelShape)this.shape, (VoxelShape)parts[i]);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, final Level world, final BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new ForgeHammerScreenHandler(syncId, inv, ContainerLevelAccess.create((Level)world, (BlockPos)pos));
            }

            public Component getDisplayName() {
                return Component.translatable((String)MIBlock.FORGE_HAMMER.asBlock().getDescriptionId());
            }
        });
        return InteractionResult.CONSUME;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

